<?php

function myconian_colorscheme_page() {
    add_submenu_page(
        'themes.php', // Parent slug. 'themes.php' is the file for the "Appearance" menu.
        'Color Scheme', // Page title.
        'Color Scheme', // Menu title.
        'manage_options', // Capability required to view this menu.
        'myconianhotel-colorscheme', // Menu slug.
        'myconianhotel_colorscheme_callback' // Function to display the content of the page.
    );
}
add_action('admin_menu', 'myconian_colorscheme_page');

function myconianhotel_colorscheme_callback() {
    // Check if the user has the required capability
    if (!current_user_can('manage_options')) {
        return;
    }

    // Save the settings if the form has been submitted
    if (isset($_POST['colorscheme_settings'])) {
        check_admin_referer('myconianhotel_colorscheme_nonce');
        update_option('myconianhotel_colorscheme', sanitize_text_field($_POST['myconianhotel_colorscheme']));
        echo '<div class="updated"><p>Settings saved.</p></div>';
    }

    // Get the current value of the option
    $myconianhotel_colorscheme = get_option( 'myconianhotel_colorscheme', '' );

    ?>
    <div class="wrap">
        <h1><?php _e('Color Scheme Page', 'myconianhotel'); ?></h1>
        <form method="post" action="">
            <?php wp_nonce_field('myconianhotel_colorscheme_nonce'); ?>
            <input type="hidden" name="colorscheme_settings" value="1">

            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><?php _e('Select Option', 'myconianhotel'); ?></th>
                    <td>
                        <select name="myconianhotel_colorscheme">
                            <option value="" <?php selected( $myconianhotel_colorscheme, 'myconianhotel' ); ?>>None</option>
                            <option value="collection" <?php selected( $myconianhotel_colorscheme, 'collection' ); ?>>Collection</option>
                            <option value="ambassador" <?php selected( $myconianhotel_colorscheme, 'ambassador' ); ?>>Ambassador</option>
                            <option value="deos" <?php selected( $myconianhotel_colorscheme, 'deos' ); ?>>Deos</option>
                            <option value="kyma" <?php selected( $myconianhotel_colorscheme, 'kyma' ); ?>>Kyma</option>
                        </select>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
