<?php

function displayCalendar(){
    // Get the current month and year
    $currentMonth = date('n');
    $currentYear = date('Y');

    // Set the starting month (May) if the current month is earlier
    $startMonth = ($currentMonth < 4) ? 4 : $currentMonth;

    // Generate calendars for the next two years
    $allMonthsHTML = '';
    for ($i = 0; $i < 12; $i++) {
        $year = $currentYear + floor(($startMonth + $i - 1) / 12);
        $month = (($startMonth - 1) + $i) % 12 + 1;
        $allMonthsHTML .= generateCalendarHTML($year, $month);
    }

    return $allMonthsHTML;
}

function generateCalendarHTML($year, $month) {
    // Get the timestamp of the first day of the month
    $firstDay = mktime(0, 0, 0, $month, 1, $year);

    // Get the number of days in the month
    $daysInMonth = date('t', $firstDay);

    // Get the day of the week for the first day of the month (1 = Monday, ..., 7 = Sunday)
    $dayOfWeek = date('N', $firstDay);

    // Get the current day, month, and year
    $currentDay = date('j');
    $currentMonth = date('n');
    $currentYear = date('Y');

    // Start building the HTML for the calendar
    $html = "<div class='calendar-wrapper'><table class='calendar'>";
    $html .= "<caption>" . date('F Y', $firstDay) . "</caption>"; // Display the month and year in the caption
    $html .= "<tr><th>M</th><th>T</th><th>W</th><th>T</th><th>F</th><th>S</th><th>S</th></tr>"; // Table header with weekdays starting from Monday
    $html .= "<tr>";

    // Add blank cells for days before the first day of the month
    for ($i = 1; $i < $dayOfWeek; $i++) {
        $html .= "<td></td>";
    }

    $open_from = get_field( 'myconianhotel_booking_open_from', 'options');
    $open_from = explode("/", $open_from);
    $open_from_d = $open_from[0] ?? 21;
    $open_from_m = $open_from[1] ?? 4;
    $open_to = get_field( 'myconianhotel_booking_open_to', 'options');
    $open_to = explode("/", $open_to);
    $open_to_d = $open_to[0] ?? 31;
    $open_to_m = $open_to[1] ?? 10;

    // Add days of the month
    for ($day = 1; $day <= $daysInMonth; $day++) {
        // Check if the day is before today
        $isPastDay = (
            $year < $currentYear ||
            ($year == $currentYear && $month < $currentMonth) ||
            ($year == $currentYear && $month == $currentMonth && $day < $currentDay) ||
            ($month > $open_to_m) || 
            ($month == $open_to_m && $day > $open_to_d ) || 
            ($month < $open_from_m) ||
            ($month == $open_from_m && $day < $open_from_d)
        );

        if ($day == 1) {
            $extra_class = 'first-of-month';
        }
        else{
            $extra_class = '';
        }

        // Apply styling based on whether the day is before today
        $style = $isPastDay ? "class='past-day'" : "class='av-day ".$extra_class."'";
        
        // Format the date in the desired format
        $formattedDate = date("Y-m-d", mktime(0, 0, 0, $month, $day, $year));
        
        // Format the b-date in the desired format
        $formattedBDate = date("D M d Y", mktime(0, 0, 0, $month, $day, $year));

        // Add the data attributes to the HTML
        $html .= "<td $style data-date='$formattedDate' data-b-date='$formattedBDate' data-time='".strtotime($formattedDate)."'><div class='day-wrapper'>$day</div></td>";

        // Start a new row after each Sunday or at the end of the month
        if (($dayOfWeek + $day - 1) % 7 === 0 || $day === $daysInMonth) {
            $html .= "</tr>";
            if ($day !== $daysInMonth) {
                $html .= "<tr>";
            }
        }
    }

    $html .= "</table></div>";

    return $html;
}




?>
