<?php

/**
 * Custom post type Document
 */
add_action('init', 'myconianhotel_create_document_post_type');
function myconianhotel_create_document_post_type() {
    $labels = array(
        'name'                  => __('Documents'),
        'singular_name'         => __('Document'),
        'menu_name'             => __('Documents'),
        'name_admin_bar'        => __('Document'),
        'add_new'               => __('Add New'),
        'add_new_item'          => __('Add New'),
        'new_item'              => __('New Document'),
        'edit_item'             => __('Edit Document'),
        'view_item'             => __('View Document'),
        'all_items'             => __('All Documents'),
        'search_items'          => __('Search Documents'),
        'not_found'             => __('No documents found.'),
        'not_found_in_trash'    => __('No documents found in Trash.'),
    );

    $args = array(
        'labels'                => $labels,
        'public'                => false,
        'rewrite'               => false,
        'has_archive'           => false,
        'publicly_queryable'    => false,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'query_var'             => true,
        'capability_type'       => 'post',
        'hierarchical'          => false,
        'menu_position'         => 5,
        'supports'              => array('title', 'custom-fields', 'page-attributes'), // 'page-attributes' for query order support
        'show_in_rest'          => true,  // Enables the Gutenberg editor
        //'taxonomies'            => [ 'document_type' ], // attach taxonomy
        'menu_icon'             => 'dashicons-format-aside'
    );

    register_post_type('document', $args);
}

add_action('init', 'myconianhotel_create_document_taxonomy');
function myconianhotel_create_document_taxonomy() {
    $labels = array(
        'name'              => 'Document Categories',
        'singular_name'     => 'Document Category',
        'search_items'      => 'Search Document Categories',
        'all_items'         => 'All Document Categories',
        'parent_item'       => 'Parent Document Category',
        'parent_item_colon' => 'Parent Document Category:',
        'edit_item'         => 'Edit Document Category',
        'update_item'       => 'Update Document Category',
        'add_new_item'      => 'Add New Document Category',
        'new_item_name'     => 'New Document Category Name',
        'menu_name'         => 'Categories',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'document-type'),
        'public'            => false,
        'show_in_rest'      => true,  // Enables the Gutenberg editor
    );

    register_taxonomy('document_type', array('document'), $args);
}

/**
 * Add custom columns to the Position edit screen
 */
add_filter( 'manage_document_posts_columns', function( $columns ) {
    $new_columns = array();

    foreach ($columns as $key => $value) {
        $new_columns[$key] = $value;

        // Insert navigation column after the Title column.
        if ('title' === $key) {
            $new_columns['myconianhotel_document_column'] = __('Attachment Type', 'myconianhotel');
            ?>
            <style>
                .column-myconianhotel_document_column ul {
                    margin: 0;
                    display: flex;
                }

                .column-myconianhotel_document_column ul li:not(:first-child):before {
                    content: ', ';
                }
            </style>
            <?php
        }
    }

    return $new_columns;
});

/*
 * Add the data to custom columns for the Accommodation edit screen
 */
add_action( 'manage_document_posts_custom_column', function( $column, $post_id ) {
    if ($column === 'myconianhotel_document_column') {
        $documents = get_field( 'myconianhotel_document', $post_id );
        if ( $documents ) {
            ?><ul><?php
            //var_dump($documents);
            foreach ( $documents as $key => $document ) {
                if ( $document ) {
                    ?><li><?php echo $key; ?></li><?php
                }
            }
            ?></ul><?php
        }
    }
}, 10, 2);