<?php

/**
 * Custom post type Event
 */
add_action('init', 'myconianhotel_create_event_post_type');
function myconianhotel_create_event_post_type() {
    $labels = array(
        'name'                  => __('Events'),
        'singular_name'         => __('Event'),
        'menu_name'             => __('Events'),
        'name_admin_bar'        => __('Event'),
        'add_new'               => __('Add New'),
        'add_new_item'          => __('Add New'),
        'new_item'              => __('New Event'),
        'edit_item'             => __('Edit Event'),
        'view_item'             => __('View Event'),
        'all_items'             => __('All Events'),
        'search_items'          => __('Search Events'),
        'not_found'             => __('No events found.'),
        'not_found_in_trash'    => __('No events found in Trash.'),
    );

    $args = array(
        'labels'                => $labels,
        'public'                => false,
        'rewrite'               => false,
        'has_archive'           => false,
        'publicly_queryable'    => false,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'query_var'             => true,
        'capability_type'       => 'post',
        'hierarchical'          => false,
        'menu_position'         => 5,
        'supports'              => array('title', 'custom-fields', 'page-attributes'), // 'page-attributes' for query order support
        'show_in_rest'          => true,  // Enables the Gutenberg editor
        'menu_icon'             => 'dashicons-calendar'
    );

    register_post_type('event', $args);
}


/**
 * Register event to be available via the REST API
 */
add_action('init', 'myconianhotel_register_event_meta');
function myconianhotel_register_event_meta() {
    register_post_meta('event', 'myconianhotel_event_file', [
        'type'         => 'string',
        'single'       => true,
        'show_in_rest' => true,
        'auth_callback' => function() { return current_user_can('edit_posts'); } // Ensures only editors can edit
    ]);
}

add_action('add_meta_boxes', 'myconianhotel_add_event_meta_box');
function myconianhotel_add_event_meta_box() {
    add_meta_box(
        'myconianhotel_event_file_meta_box',  // Unique ID
        'Event File URL',                     // Title
        'myconianhotel_event_file_callback',  // Callback function
        'event',                              // Post type (CPT)
        'side',                               // Context (normal, side, etc.)
        'default'                             // Priority
    );
}

function myconianhotel_event_file_callback($post) {
    // Retrieve existing value
    $value = get_post_meta($post->ID, 'myconianhotel_event_file', true);

    // Security nonce field
    wp_nonce_field('myconianhotel_event_file_save', 'myconianhotel_event_file_nonce');

    // Input field
    echo '<input type="text" name="myconianhotel_event_file" value="' . esc_attr($value) . '" style="width:100%;" placeholder="Enter File URL">';
}

add_action('save_post_event', 'myconianhotel_save_event_meta');
function myconianhotel_save_event_meta($post_id) {
    // Check if nonce is set
    if (!isset($_POST['myconianhotel_event_file_nonce']) || 
        !wp_verify_nonce($_POST['myconianhotel_event_file_nonce'], 'myconianhotel_event_file_save')) {
        return;
    }

    // Check if user has permission to edit
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    // Prevent autosave from overriding data
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // Save meta field
    if (isset($_POST['myconianhotel_event_file'])) {
        update_post_meta($post_id, 'myconianhotel_event_file', sanitize_text_field($_POST['myconianhotel_event_file']));
    } else {
        delete_post_meta($post_id, 'myconianhotel_event_file');
    }
}