<?php 

function create_hotel_post_type() {
    $labels = array(
        'name'               => 'Hotels',
        'singular_name'      => 'Hotel',
        'menu_name'          => 'Hotels',
        'name_admin_bar'     => 'Hotel',
        'add_new'            => 'Add New',
        'add_new_item'       => 'Add New Hotel',
        'new_item'           => 'New Hotel',
        'edit_item'          => 'Edit Hotel',
        'view_item'          => 'View Hotel',
        'all_items'          => 'All Hotels',
        'search_items'       => 'Search Hotels',
        'not_found'          => 'No hotels found.',
        'not_found_in_trash' => 'No hotels found in Trash.',
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'mykonos-accommodation'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 5,
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt'),
        'show_in_rest'       => true,  // Enables the Gutenberg editor
        'menu_icon'          => 'dashicons-admin-multisite'
    );

    register_post_type('hotel', $args);
}
add_action('init', 'create_hotel_post_type');


function create_location_taxonomy() {
    $labels = array(
        'name'              => 'Locations',
        'singular_name'     => 'Location',
        'search_items'      => 'Search Locations',
        'all_items'         => 'All Locations',
        'parent_item'       => 'Parent Location',
        'parent_item_colon' => 'Parent Location:',
        'edit_item'         => 'Edit Location',
        'update_item'       => 'Update Location',
        'add_new_item'      => 'Add New Location',
        'new_item_name'     => 'New Location Name',
        'menu_name'         => 'Locations',
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'accommodation'),
        'show_in_rest'       => true,  // Enables the Gutenberg editor
    );

    register_taxonomy('location', array('hotel'), $args);
}
add_action('init', 'create_location_taxonomy');

function create_group_taxonomy() {
    $labels = array(
        'name'              => 'Affiliations',
        'singular_name'     => 'Affiliation',
        'search_items'      => 'Search Affiliations',
        'all_items'         => 'All Affiliations',
        'parent_item'       => 'Parent Affiliation',
        'parent_item_colon' => 'Parent Affiliation:',
        'edit_item'         => 'Edit Affiliation',
        'update_item'       => 'Update Affiliation',
        'add_new_item'      => 'Add New Affiliation',
        'new_item_name'     => 'New Affiliation Name',
        'menu_name'         => 'Affiliations',
    );

    $args = array(
        'hierarchical'      => true, // Flat taxonomy
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'group'),
        'show_in_rest'       => true,  // Enables the Gutenberg editor
    );

    register_taxonomy('group', array('hotel'), $args);
}
add_action('init', 'create_group_taxonomy');

function create_consortium_taxonomy() {
    $labels = array(
        'name'              => 'Consortiums',
        'singular_name'     => 'Consortium',
        'search_items'      => 'Search Consortiums',
        'all_items'         => 'All Consortiums',
        'parent_item'       => 'Parent Consortium',
        'parent_item_colon' => 'Parent Consortium:',
        'edit_item'         => 'Edit Consortium',
        'update_item'       => 'Update Consortium',
        'add_new_item'      => 'Add New Consortium',
        'new_item_name'     => 'New Consortium Name',
        'menu_name'         => 'Consortiums',
    );

    $args = array(
        'hierarchical'      => true, // Flat taxonomy
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'consortium'),
        'show_in_rest'       => true,  // Enables the Gutenberg editor
    );

    register_taxonomy('consortium', array('hotel'), $args);
}
add_action('init', 'create_consortium_taxonomy');

function create_myconianhotel_type_taxonomy() {
    $labels = array(
        'name'              => 'Types',
        'singular_name'     => 'Type',
        'search_items'      => 'Search Types',
        'all_items'         => 'All Types',
        'parent_item'       => 'Parent Type',
        'parent_item_colon' => 'Parent Type:',
        'edit_item'         => 'Edit Type',
        'update_item'       => 'Update Type',
        'add_new_item'      => 'Add New Type',
        'new_item_name'     => 'New Type Name',
        'menu_name'         => '- Types',
    );

    $args = array(
        'hierarchical'      => true, // Flat taxonomy
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'type'),
        'show_in_rest'       => true,  // Enables the Gutenberg editor
    );

    register_taxonomy('myconianotel_type', array('hotel'), $args);
}
add_action('init', 'create_myconianhotel_type_taxonomy');


function add_hotel_altname_meta_box() {
    add_meta_box(
        'hotel_altname_meta_box',
        'Hotel Alternative name',
        'hotel_altname_meta_box_callback',
        'hotel',
        'side',
        'default'
    );
}
//add_action('add_meta_boxes', 'add_hotel_altname_meta_box');

function hotel_altname_meta_box_callback($post) {
    wp_nonce_field('save_hotel_altname', 'hotel_altname_nonce');
    $value = get_post_meta($post->ID, '_hotel_altname', true);
    echo '<input type="text" id="hotel_altname" name="hotel_altname" value="' . esc_attr($value) . '" style="width:100%" />';
}

function save_hotel_altname($post_id) {
    if (!isset($_POST['hotel_altname_nonce']) || 
        !wp_verify_nonce($_POST['hotel_altname_nonce'], 'save_hotel_altname')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['hotel_altname'])) {
        $altname = sanitize_text_field($_POST['hotel_altname']);
        update_post_meta($post_id, '_hotel_altname', $altname);
    }
}
add_action('save_post', 'save_hotel_altname');

function add_hotel_url_meta_box() {
    add_meta_box(
        'hotel_url_meta_box',
        'Hotel url',
        'hotel_url_meta_box_callback',
        'hotel',
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'add_hotel_url_meta_box');

function hotel_url_meta_box_callback($post) {
    wp_nonce_field('save_hotel_url', 'hotel_url_nonce');
    $value = get_post_meta($post->ID, '_hotel_url', true);
    echo '<input type="url" id="hotel_url" name="hotel_url" value="' . esc_attr($value) . '" style="width:100%" />';
}

function save_hotel_url($post_id) {
    if (!isset($_POST['hotel_url_nonce']) || 
        !wp_verify_nonce($_POST['hotel_url_nonce'], 'save_hotel_url')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['hotel_url'])) {
        $url = sanitize_text_field($_POST['hotel_url']);
        update_post_meta($post_id, '_hotel_url', $url);
    }
}
add_action('save_post', 'save_hotel_url');

function add_hotel_booking_platform_url_meta_box() {
    add_meta_box(
        'hotel_booking_platform_url_meta_box',
        'Booking platform Url',
        'hotel_booking_platform_url_meta_box_callback',
        'hotel',
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'add_hotel_booking_platform_url_meta_box');

function hotel_booking_platform_url_meta_box_callback($post) {
    wp_nonce_field('save_hotel_booking_platform_url', 'hotel_booking_platform_url_nonce');
    $value = get_post_meta($post->ID, '_hotel_booking_platform_url', true);
    echo '<input type="url" id="hotel_booking_platform_url" name="hotel_booking_platform_url" value="' . esc_attr($value) . '" style="width:100%" />';
}

function save_hotel_booking_platform_url($post_id) {
    if (!isset($_POST['hotel_booking_platform_url_nonce']) || 
        !wp_verify_nonce($_POST['hotel_booking_platform_url_nonce'], 'save_hotel_booking_platform_url')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['hotel_booking_platform_url'])) {
        $url = sanitize_text_field($_POST['hotel_booking_platform_url']);
        update_post_meta($post_id, '_hotel_booking_platform_url', $url);
    }
}
add_action('save_post', 'save_hotel_booking_platform_url');


//if ( 'collection' == get_option( 'myconianhotel_colorscheme' ) ) {
    add_action('rest_api_init', 'register_hotel_json_feed');
//}

function register_hotel_json_feed() {
    register_rest_route('custom/v1', '/hotels', array(
        'methods' => 'GET',
        'callback' => 'get_hotels_json_feed',
        'permission_callback' => '__return_true',
    ));
}

function get_hotels_json_feed() {
    $args = array(
        'post_type'         => 'hotel',
        'post_status'       => 'publish',
        'posts_per_page'    => -1,
    );

    $query = new WP_Query($args);
    $hotels = array();

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            
            // Get location term
            $location_terms = get_the_terms( get_the_ID(), 'location' );
            if ( $location_terms && ! is_wp_error( $location_terms ) ) {
                $location_term = $location_terms[0]; // Get the first term
                $location = array(
                    'name'          => $location_term->name,
                    'id'            => $location_term->term_id,
                    'description'   => $location_term->description,
                    'link'          => get_term_link( $location_term )
                );
            } else {
                $location = array(
                    'name'          => null,
                    'id'            => null,
                    'description'   => null,
                    'link'           => null,
                );
            }
            
            // Get group term
            $groups = [];
            $group_terms = get_the_terms( get_the_ID(), 'group' );
            if ( $group_terms && ! is_wp_error( $group_terms ) ) {
                foreach ( $group_terms as $key => $group_term ) {
                    $groups[] = array(
                        'name'          => $group_term->name,
                        'id'            => $group_term->term_id,
                        'description'   => $group_term->description,
                        'link'          => get_term_link( $group_term ),
                        'logo'          => get_field( 'myconianhotel_term_logo', 'group_' . $group_term->term_id ),
                        'style'         => get_term_meta( $group_term->term_id, 'myconianhotel-style', true )
                    );
                }
            }
            
            // Get consortium term
            $consortiums = [];
            $consortium_terms = get_the_terms( get_the_ID(), 'consortium' );
            if ( $consortium_terms && ! is_wp_error( $consortium_terms ) ) {
                foreach ( $consortium_terms as $key => $consortium_term ) {
                    $consortiums[] = array(
                        'name'          => $consortium_term->name,
                        'id'            => $consortium_term->term_id,
                        'description'   => $consortium_term->description,
                        'link'          => get_term_link( $consortium_term ),
                        'logo'          => get_field( 'myconianhotel_term_logo', 'consortium_' . $consortium_term->term_id ),
                        'style'         => get_term_meta( $consortium_term->term_id, 'myconianhotel-style', true )
                    );
                }
            }

            // Get type term
            $type_terms = get_the_terms( get_the_ID(), 'myconianotel_type' );
            if ( $type_terms && ! is_wp_error( $type_terms ) ) {
                $type_term = $type_terms[0]; // Get the first term
                $type = array(
                    'name'          => $type_term->name,
                    'id'            => $type_term->term_id,
                    'description'   => $type_term->description,
                    'link'          => get_term_link( $type_term )
                );
            } else {
                $type = array(
                    'name'          => null,
                    'id'            => null,
                    'description'   => null,
                    'link'          => null,
                );
            }
            
            // Get altname meta field
            $altname = get_post_meta( get_the_ID(), '_hotel_altname', true);

            $hotels[] = array(
                'id'                            => get_the_ID(),
                'hotel_url'                     => get_post_meta( get_the_ID(), '_hotel_url', true),
                'hotel_booking_platform_url'    => get_post_meta( get_the_ID(), '_hotel_booking_platform_url', true),
                'title'                         => get_the_title(),
                'description'                   => wpautop( get_the_content() ), // Converts line breaks to <p> tags
                'featured_image'                => get_the_post_thumbnail_url( get_the_ID(), 'full' ),
                'permalink'                     => get_the_permalink( get_the_ID() ),
                'location'                      => $location,
                'type'                          => $type,
                'groups'                        => $groups,
                'consortiums'                   => $consortiums
            );
        }
    }
    wp_reset_postdata();

    return rest_ensure_response(
        array(
            'hotels' => $hotels,
            'collection' => array(
                'bloginfo_name' => get_bloginfo( 'name' ),
                'bloginfo_url' => get_bloginfo( 'url' ),
                'hotel_post_type_archive_link' => get_post_type_archive_link( 'hotel' )
            )
        )
    );
}



?>