<?php

/**
 * Custom post type Menu
 */
add_action('init', 'myconianhotel_create_menu_post_type');
function myconianhotel_create_menu_post_type() {
    $labels = array(
        'name'                  => __('Menus'),
        'singular_name'         => __('Menu'),
        'menu_name'             => __('Menus'),
        'name_admin_bar'        => __('Menu'),
        'add_new'               => __('Add New'),
        'add_new_item'          => __('Add New'),
        'new_item'              => __('New Menu'),
        'edit_item'             => __('Edit Menu'),
        'view_item'             => __('View Menu'),
        'all_items'             => __('All Menus'),
        'search_items'          => __('Search Menus'),
        'not_found'             => __('No menus found.'),
        'not_found_in_trash'    => __('No menus found in Trash.'),
    );

    $args = array(
        'labels'                => $labels,
        'public'                => false,
        'rewrite'               => false,
        'has_archive'           => false,
        'publicly_queryable'    => false,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'query_var'             => true,
        'capability_type'       => 'post',
        'hierarchical'          => false,
        'menu_position'         => 5,
        'supports'              => array('title', 'page-attributes'), // 'page-attributes' for query order support
        'show_in_rest'          => true,  // Enables the Gutenberg editor
        'menu_icon'             => 'dashicons-food'
    );

    register_post_type('menu', $args);
}


/**
 * Register menu to be available via the REST API
 */
add_action('init', 'myconianhotel_register_menu_meta');
function myconianhotel_register_menu_meta() {
    register_post_meta('menu', 'myconianhotel_menu_file', [
        'type'         => 'string',
        'single'       => true,
        'show_in_rest' => true,
        'auth_callback' => function() { return current_user_can('edit_posts'); } // Ensures only editors can edit
    ]);
}