<?php

/**
 * Customize Yoast SEO
 * 
 * Add Related Archive column to the page edit screen
 * Make the Related Archive column sortable
 * Add the data to the Related Archive column for the page edit screen
 */

$colorscheme = get_option( 'myconianhotel_colorscheme' );

// Custom post type Hotels
if ( 'collection' == $colorscheme ) {
    include('custom-post-type-hotels.php');
}

// Custom post type Accommodation
if ( 'collection' !== $colorscheme ) {
    include('custom-post-type-accommodation.php');
}

// Custom post type Restaurants
if ( 'collection' == $colorscheme ) {
    include('custom-post-type-restaurants.php');
}

// Custom post type Gallery
if ( 'collection' !== $colorscheme ) {
    //include('custom-post-type-gallery.php');
}

// Custom post type position
if ( 'collection' == $colorscheme ) {
    include('custom-post-type-position.php');
}

// Custom post type event
//if ( 'collection' == $colorscheme ) {
    //include('custom-post-type-event.php'); // TODO: remove after migrate menus & events to document post type
//}

// Custom post type position
if ( 'collection' !== $colorscheme ) {
    //include('custom-post-type-menu.php'); // TODO: remove after migrate menus & events to document post type
}

include('custom-post-type-document.php');

// Customize Yoast SEO
require_once __DIR__ . '/YoastSEO-customize.php';

/**
 * Add Related Archive column to the page edit screen
 */
add_filter( 'manage_pages_columns', 'myconianhotel_manage_pages_columns' );/////
function myconianhotel_manage_pages_columns($columns) {
    return myconianhotel_array_insert_after(
        $columns,
        'title',
        array( 'myconianhotel_column_related_archive' => __( 'Related Archive', 'myconianhotel' ))
    );
}

/**
 * Make the Related Archive column sortable
 */
add_filter('manage_edit-page_sortable_columns', 'myconianhotel_page_sortable_columns');
function myconianhotel_page_sortable_columns($sortable_columns) {
    $sortable_columns['myconianhotel_column_related_archive'] = 'myconianhotel_related_object';
    return $sortable_columns;
}

/**
 * Add the data to the Related Archive column for the Page edit screen
 */
add_action( 'manage_pages_custom_column' , 'custom_accommodation_column', 10, 2 );/////
function custom_accommodation_column( $column, $post_id ) {
    switch ( $column ) {
        case 'myconianhotel_column_related_archive' :
            $options = get_post_meta( $post_id, 'myconianhotel_related_object', true );
            ///var_dump($options);
            if ( ! empty( $options ) ) {
                foreach ( $options as $option ) {
                    ?><a href="<?php echo $option['link'] ?>" target="_blank"><?php echo $option['title'] ?></a><br /><?php                    
                }
            }
            break;
    }
}
