<?php

/**
 * Load front-end assets
 * Load modal front-end assets
 */

/**
 * Load front-end assets
 */
add_action( 'wp_enqueue_scripts', 'theme_scripts_and_styles' );
function theme_scripts_and_styles() {
    $theme = wp_get_theme();
    $version = $theme->get( 'Version' );

    wp_register_style( 'wp-block-library-myconianhotel', get_stylesheet_directory_uri() . '/assets/css/wp-block-library-myconianhotel.css', array(), $version );
    wp_enqueue_style( 'wp-block-library-myconianhotel');

    $myconianhotel_colorscheme = get_option( 'myconianhotel_colorscheme', null );

    wp_register_style( 'theme-owl', get_stylesheet_directory_uri() . '/assets/css/vendors/owl.carousel.min.css', array(), $version );
    wp_enqueue_style( 'theme-owl');

    wp_register_style( 'theme-main', get_stylesheet_directory_uri() . '/assets/css/main.css', array(), $version );
    wp_enqueue_style( 'theme-main');

    $file_path = '/assets/css/wp-block-library-' . $myconianhotel_colorscheme . '.css';
    if ( $myconianhotel_colorscheme && file_exists( get_stylesheet_directory() . $file_path ) ) {
        wp_register_style( 'wp-block-library-' . $myconianhotel_colorscheme, get_stylesheet_directory_uri() . $file_path, array(), $version );
        wp_enqueue_style( 'wp-block-library-' . $myconianhotel_colorscheme);
    }

    wp_register_script( 'theme-owl', get_stylesheet_directory_uri() . '/assets/js/vendors/owl.carousel.min.js', array(), '2.3.4' , true );
    wp_enqueue_script('theme-owl');

    wp_register_script( 'theme-lottie', get_stylesheet_directory_uri() . '/assets/js/vendors/lottie.min.js', array(), '5.7.13', true );
    wp_enqueue_script('theme-lottie'); 

    wp_register_script( 'theme-popper', get_stylesheet_directory_uri() . '/assets/js/vendors/popper.min.js', array(), '', true );
    wp_enqueue_script('theme-popper');

    wp_register_script( 'theme-tippy', get_stylesheet_directory_uri() . '/assets/js/vendors/tippy-bundle.umd.min.js', array('theme-popper'), '', true );
    wp_enqueue_script('theme-tippy');

    wp_register_script( 'theme-lottie-interactivity', get_stylesheet_directory_uri() . '/assets/js/vendors/lottie-interactivity.min.js', array(), null, true );
    wp_enqueue_script('theme-lottie-interactivity');

    wp_register_script( 'theme-main', get_stylesheet_directory_uri() . '/assets/js/main.js', array('jquery', 'theme-owl', 'theme-lottie', 'theme-lottie-interactivity', 'theme-tippy' ), $version , true );
    wp_enqueue_script( 'theme-main' );

    wp_localize_script( 'theme-main', 'theme', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'baseurl' => get_bloginfo( 'url' )
    ) );
}

/**
 * Load modal front-end assets
 */
add_action( 'get_template_part_template-parts/modal', 'myconianhotel_modal_frontend_assets', 100, 3 );
function myconianhotel_modal_frontend_assets($slug, $name, $args) {
    if ( 'form' == $name) {
            wp_enqueue_script( 'myconianhotel-modal', get_template_directory_uri() . '/assets/js/modal.js', array( 'jquery' ) );

    }
}