(function($){

$(document).ready(function(){

Filters();

// Animate Free text block
$('.wp-block-myconianhotel-free-text.has-text #filter-text-wrap').css({height: Math.ceil($('#filter-text').height())});

$( window ).on( "resize", function() {
	// Animate Free text block
  	$('#filter-text-wrap').css({height: 'auto'});
});

var doit;
window.onresize = function(){
  clearTimeout(doit);
  doit = setTimeout(function(){
  	// Animate Free text block
  	const height = Math.ceil($('#filter-text').height());
  	$('#filter-text-wrap').css({height: height});
  },100);
};

/**
 * Filters
 */
function Filters() { if (!$('#accommodation-filters').length) return;
	// ok
	$('[data-filter]').on('click', function(e) {
		e.preventDefault();
		$(this).closest('.filter-options-JS').find('[data-filter]').removeClass('is-active');
		$(this).toggleClass('is-active');
		$(`[data-filter_target=${$(this).closest('ul').attr('id')}]`).find('.filter-selected-JS').html($(this).data('filter_value'));
		//
		filter();
		
		// Animate Free text block
		const newText = $(this).data('filter_text');
		$('#filter-text').addClass('hide').text(newText);

		setTimeout(function(){
			const height = Math.ceil($('#filter-text').height());

			if (newText) {
				$('#filter-text').closest('.wp-block-myconianhotel-free-text').addClass('has-text');
			} else {
				$('#filter-text').closest('.wp-block-myconianhotel-free-text').removeClass('has-text');				
			}

			$('#filter-text-wrap').animate({
			    	height: height + 'px'
			  	}, 300, function() {
			  		$('#filter-text').removeClass('hide');
			  	});
		}, 10);
	});
	// ok
	$('.filter-selected-JS').on('click', function(e) {
		e.stopPropagation()
		$(`#${$(this).closest('[data-filter_target]').data('filter_target')} .is-active`).removeClass('is-active');
		$(this).text('');
		//
		filter();
	});
	//
	$('[data-filter_target]').on('click', function(e) {
		$('[data-filter_target]').removeClass('is-active');
		$('.filter-options-JS').removeClass('is-active');
		$(this).addClass('is-active');
		$(`#${$(this).data('filter_target')}`).addClass('is-active');
		//$('#accommodation-filters').addClass('is-open');
	});
	//
	$('#accommodation-filters').on('mouseleave', function(e) {
		//$(this).removeClass('is-open');
		/////$('.filter-JS').removeClass('is-active');
		/////$('.filter-options-JS').removeClass('is-active');
	});
	// Compare event
	$('#compare-btn').on('click', function() {
		const currentText = $(this).html();
		const toggleText = $(this).attr('data-toggle_text');

		$(this).html(toggleText);
		$(this).attr('data-toggle_text', currentText);

		// Reset filters
		$(this).closest('.wp-block-myconianhotel-accommodation-filters').find('[data-filter]').removeClass('is-active');
		$(this).closest('.wp-block-myconianhotel-accommodation-filters').find('[data-filter_value="all"]').addClass('is-active');
		filter();

		$('body').toggleClass('compare-is-active');
		//if ($('.compare-is-active').length) {
			//scrollToFilters(500);
		//}
	});
	//
	/*const el = document.querySelector("#accommodation-filters")
	const observer = new IntersectionObserver( 
	  ([e]) => e.target.classList.toggle("is-pinned", e.intersectionRatio < 1),
	  { threshold: [1] }
	);

	observer.observe(el);*/

	/*$(document).on('click', function(e){
	    if ((!$('#accommodation-filters').is(e.target) && $('#accommodation-filters').has(e.target).length === 0)) {
	        $('.filter-JS').removeClass('is-active');
	    }	
	});*/  

	function filter() {
		let filters = {}, articleAttributes = {}
		const $activeFilters = $('[data-filter].is-active');
		const $articles = $('[data-filter_attributes]');

		$.each($activeFilters, function() {
			if ('all' == $(this).data('filter_value')) {
				scrollToFilters();
				return false;
			}

			filters[$(this).data('filter')] = $(this).data('filter_value');
		});

		if ($.isEmptyObject(filters)) {
			$articles.removeClass('is-inactive');
			return;
		}

		$.each($articles, function() {
			articleAttributes = $(this).data('filter_attributes');
			
			$(this).removeClass('is-inactive');
			for (const attribute in filters) {
				if (filters[attribute] != articleAttributes[attribute]) {
					$(this).addClass('is-inactive');
					break;
				}
			}	
		});

		scrollToFilters();
	}
	
	function scrollToFilters(time=500) { //return;
		const navHeight = $('#main-nav').length ? $('#main-nav').height() : 0;
		const scrolTopMargin = $('.wp-block-myconianhotel-archive').eq(0).position().top - $('#main-nav').height();
		
		///setTimeout( function() {
			$('body, html').animate({
	            //scrollTop: $(window).height() + navHeight - margin
	            scrollTop: scrolTopMargin + 1
	        }, time, function(){
	        	/////$('#accommodation-filters').removeClass('is-open');
				/////$('.filter-JS').removeClass('is-active');

	        });
		///},10)
	}
}

})

})(jQuery)