<?php

/**
 * Add custom fields to ACF Attributes field group child fields
 *  myconian_is_filter
 *  myconian_compare
 *  myconian_featured_attr
 *  myconian_text_before_value
 *  myconian_text_after_value
 * 
 * Filter ACF Attributes field group child fields format
 * 
 * Merge Accomodation's attributes to archive filters & create Accomodation's data attributes
 * 
 * Transform accomodation terms to filters
 * 
 * Create helper array for myconianhotel/post-acf-fields
 * 
 * Load filters front-end assets
 *
 */

/**
 * Add custom fields to ACF Attributes field group child fields
 */
add_action( 'acf/render_field_settings', 'myconian_render_field_settings' );
function myconian_render_field_settings( $field ) {
    if ( strpos( $field['wrapper']['class'], 'myconian_attribute_field' ) !== false ) {
        acf_render_field_setting( $field, array(
            'label'         => __('Use attribute as filter'),
            'instructions'  => '',
            'name'          => 'myconian_is_filter',
            'type'          => 'true_false',
            'ui'            => 1,
        ), true);

        acf_render_field_setting( $field, array(
            'label'         => __('Add attribute to compare table'),
            'instructions'  => '',
            'name'          => 'myconian_compare',
            'type'          => 'true_false',
            'ui'            => 1,
        ), true);

        acf_render_field_setting( $field, array(
            'label'         => __('Featured attribute'),
            'instructions'  => '',
            'name'          => 'myconian_featured_attr',
            'type'          => 'true_false',
            'ui'            => 1,
        ), true);

        acf_render_field_setting( $field, array(
            'label'         => __('Text before value'),
            'instructions'  => '',
            'name'          => 'myconian_text_before_value',
            'type'          => 'text',
            'ui'            => 1,
        ), true);

        acf_render_field_setting( $field, array(
            'label'         => __('Text after value'),
            'instructions'  => '',
            'name'          => 'myconian_text_after_value',
            'type'          => 'text',
            'ui'            => 1,
        ), true);

        acf_render_field_setting( $field, array(
            'label'         => __('Text after value (singular)'),
            'instructions'  => '',
            'name'          => 'myconian_text_after_value_singular',
            'type'          => 'text',
            'ui'            => 1,
        ), true);
    }
}

/**
 * Filter ACF Attributes field group child fields format
 */
add_filter( 'acf/format_value', 'myconianhotel_format_accomodation_attributes', 10, 3 );
function myconianhotel_format_accomodation_attributes( $value, $post_id, $field ) {
    // If is myconian_room_attributes child
    // and is text or mumber type
    if (
        str_contains( $field['name'], 'myconian_room_attributes_' )
        // && ( 'text' == $field['type'] || 'number' == $field['type'] )
    ) {

        $text_after_value_key = $value == 1 ? 'myconian_text_after_value_singular' : 'myconian_text_after_value';

        return [
            'title' => $field['label'],
            'value' => $value,
            'type' => $field['type'],
            'before_value' => $field['myconian_text_before_value'] ?? '',
            'after_value' => $field[$text_after_value_key] ?? '',
            'full_label' => $value ?
            ( 
                    ( isset( $field['myconian_text_before_value'] ) && $field['myconian_text_before_value'] ? $field['myconian_text_before_value'] . ' ' : '' ) . // Before value
                    ( isset( $field['choices'] ) && $value ? $field['choices'][$value['value']] : $value ) . // Value
                    ( isset( $field[$text_after_value_key] ) && $field[$text_after_value_key] ? ' ' . $field[$text_after_value_key] : '' ) // After value
            ) :
            '',
            'is_filter' => $field['myconian_is_filter'] ?? false,
            'is_compare' => $field['myconian_compare'] ?? false,
            'is_featured' => $field['myconian_featured_attr'] ?? false
        ];
    }

    return $value;
}

/**
 * Merge Accomodation's attributes to archive filters & create Accomodation's data attributes
 */
function myconianhotel_merge_accommodation_attributes_to_archive_filters( $taxonomy, $filters, $filters_and_compare, $attributes, $post_id ) {
    $data_attributes = '';
    $data_attributes = "data-filter_attributes='{";
    
    $type = get_the_terms( $post_id, $taxonomy );
    if ( $type ) {
        $data_attributes .= '"' . $taxonomy ."\":\"" . $type[0]->slug . '",';
    }

    if ( $type || $attributes ) {
        foreach ( $attributes as $key => $attr ) {
            if ( $attr['is_filter'] || $attr['is_compare'] ) {
                // Check type of attribute
                if ( is_array( $attr['value'] ) ) {
                    $value = $attr['value']['value'];                    
                } else {
                    $value = $attr['value'];
                }

                // Filters only
                if ( $attr['is_filter'] ) {
                    // Data attributes for filterable element
                    $data_attributes .= $attr['is_filter'] ? "\"" . $key . '":"' . $value . '",' : '';
                }
                // Filters & compare
                if ( $attr['is_filter'] || $attr['is_compare'] ) {
                    // Title of filter
                    $filters_and_compare[$key]['title'] = $attr['title'];
                    // Type of filter (compare only or not)
                    $filters_and_compare[$key]['compare'] = $attr['is_compare'] && $attr['is_filter'] ? 2 : ( $attr['is_compare'] && ! $attr['is_filter'] ? 1 : 0 ); // compare + filter = 2 | compare only = 1 | 0
                    // Values of filter
                    $filters_and_compare[$key]['values'][] = $value;
                    $filters_and_compare[$key]['full_labels'][] = $attr['full_label'] ?? $value;
                    // Unique filter values
                    $filters_and_compare[$key]['values'] = array_unique( $filters_and_compare[$key]['values'] );
                    // Sort filter values
                    if ( 'number' === $attr['type'] ) {
                        sort( $filters_and_compare[$key]['values'] );
                    }
                }

            }
        }
    }
 
    $data_attributes = trim($data_attributes, ",");
    $data_attributes .= "}'";

    return array(
        'filters_and_compare' => $filters_and_compare,
        'data_attributes' => $data_attributes
    );
}

/**
 * Transform accomodation terms to filters
 */
function myconianhotel_transform_accommodation_terms_to_archive_filters( $taxonomy, $terms ) {

    if ( $taxonomy && $terms ) {
        $transformed_terms[$taxonomy] = array(
            'title' => 'Type', // TODO: dynamic
            'compare' => 2, // compare + filter = 2
            'values' => array(),
            'full_labels' => array(),
        );

        foreach ( $terms as $term ) {
            $transformed_terms[$taxonomy]['ids'][] = $term->term_id;
            $transformed_terms[$taxonomy]['values'][] = $term->slug;
            $transformed_terms[$taxonomy]['full_labels'][] = $term->name;
            $transformed_terms[$taxonomy]['urls'][] = get_term_link( $term->term_id );
        }
    }

    return $transformed_terms ?? array();
}

/**
 * Create helper array for myconianhotel/post-acf-fields
 */
function myconianhotel_accommodation_attributes_helper() {
    $field_obj = acf_get_field( 'myconian_room_attributes' );
    $result = array();

    if ( isset( $field_obj['sub_fields'] ) && ! empty( $field_obj['sub_fields'] ) ) {
        foreach ( $field_obj['sub_fields'] as $field ) {
            $result[$field['name']] = array(
                'title' => $field['label'],
                'before_value' => $field['myconian_text_before_value'] ?? '',
                'after_value' => $field['myconian_text_after_value'] ?? '',
                'after_value_singular' => $field['myconian_text_after_value_singular'] ?? '',
                'choices' => $field['choices'] ?? null
            );
        }

    }

    return $result;
}

/**
 * Load filters front-end assets
 */
add_action( 'get_template_part_template-parts/filters', 'myconianhotel_filters_frontend_assets', 10, 3 );
function myconianhotel_filters_frontend_assets($slug, $name, $args) {
    wp_enqueue_script( 'myconianhotel-filters', get_template_directory_uri() . '/inc/filters/assets/js/index.js', array( 'jquery' ) );
}