<?php
$is_related_page 	= $args['is_related_page'] ?? true;
$filters 			= $args['filters'] ?? array();
$post_type 			= $args['post_type'] ?? null;
$compare 			= $args['compare'] ?? false;
$taxonomy 			= $args['taxonomy'] ?? false;
$options_page 		= $post_type . '_archive_page';
$all_text 			= $is_related_page ? ( get_field( 'myconianhotel_free_text_block', $options_page )['text'] ?? '' ) : '';
$queried_object = get_queried_object();

if ( ! empty( $filters ) ) :

	if ( is_tax() ) :
		foreach ( $filters as $key => $filter ) :
			if ( $compare && $filter['compare'] ) : // is compare only
			?>
			<div class="compare-title"><?php echo $filter['title']; ?></div>		
			<?php
			endif;
			
			if ( 2 == $filter['compare'] ) : // is filter & compare
			?>
			<ul class="filter-options is-active">
				<li class="filter-option"><a href="<?php echo get_post_type_archive_link( $post_type ); ?>">All</a></li>
				<?php foreach ( $filter['values'] as $index => $value ) : ?>
				<li class="filter-option"><a href="<?php echo $filter['urls'][$index]; ?>" <?php echo $filter['values'][$index] == $queried_object->slug ? ' class="is-active"' : ''?>><?php echo $filter['full_labels'][$index]; ?></a></li>
				<?php endforeach; ?>
			</ul>
			<?php
			endif;
		endforeach;
	else :
		foreach ( $filters as $key => $filter ) :
			if ( $compare && $filter['compare'] ) : // is compare only
			?>
			<div class="compare-title"><?php echo $filter['title']; ?></div>		
			<?php
			endif;
			
			if ( 2 == $filter['compare'] ) : // is filter & compare
			?>
			<ul id="filter-<?php echo $key; ?>" class="filter-options filter-options-JS is-active">
				<li class="filter-option"><a href="#" class="is-active" data-filter="<?php echo $key ?>" data-filter_value="all" data-filter_text="<?php echo $all_text; ?>" rel="nofollow">All</a></li>
				<?php
				foreach ( $filter['values'] as $index => $value ) :
					$acf_fields = get_field( 'myconianhotel_free_text_block', $taxonomy . '_' . $filter['ids'][$index] );
					?>
				<li class="filter-option"><a href="#" data-filter="<?php echo $key ?>" data-filter_value="<?php echo $value; ?>" data-filter_text="<?php echo wp_strip_all_tags($acf_fields['text'] ?? '' ); ?>" rel="nofollow"><?php echo $filter['full_labels'][$index]; ?></a></li>
					<?php
				endforeach;
			?>
			</ul>
			<?php
			endif;
		endforeach;
	endif;	

	if ( $compare ) {
		get_template_part( 'inc/filters/compare-button' );
	}
	
endif;