<?php
$options_page = $args['options_page'] ?? null;
$taxonomy = $args['taxonomy'] ?? null;
$get_queried_object_id = get_queried_object_id();

if ( $options_page ) {
	$media_type = null;
	$media_id = null;
	$media_url = null;

	// First look at taxonomy, then at archive
	$video = get_field( 'myconianhotel_hero_block_video', $taxonomy . '_' . $get_queried_object_id );
	$video = $video ? $video : get_field( 'myconianhotel_hero_block_video', $options_page );
	$image = get_field( 'myconianhotel_hero_block_image', $taxonomy . '_' . $get_queried_object_id  );
	$image = $image ? $image : get_field( 'myconianhotel_hero_block_image', $options_page );

	if ( $video ) {
		$media_type = 'video';
		$media_id = $video['ID'];
		$media_url = $video['url'];
	} else if ( $image ) {
		$media_type = 'image';
		$media_id = $image['ID'];
		$media_url = $image['url'];
	}

	if ( $media_id ) {
		// First look at taxonomy, then at archive
		$subtitle = get_field( 'myconianhotel_hero_block_subtitle', $taxonomy . '_' . $get_queried_object_id  );
		$subtitle = $subtitle ? $subtitle : get_field( 'myconianhotel_hero_block_subtitle', $options_page );
		$header = get_field( 'myconianhotel_hero_block_header', $taxonomy . '_' . $get_queried_object_id  );
		$header = $header ? $header : get_field( 'myconianhotel_hero_block_header', $options_page );
		$overlay = get_field( 'myconianhotel_hero_block_overlay', $taxonomy . '_' . $get_queried_object_id  ) ?? '0.25';
		$overlay = $overlay ? $overlay : get_field( 'myconianhotel_hero_block_overlay', $options_page ) ?? '0.25';


		$poster = $image ? '"poster":"' . $image['url'] . '","posterId":' . $image['ID'] . ',' : '';

		$block =
		'<!-- wp:myconianhotel/hero {"mediaId":' . $media_id . ',"mediaUrl":"' . $media_url . '","mediaType":"' . $media_type . '","mediaOrientation":"landscape","aspectRatio":"16/9",' . $poster . '"overlay":"' . $overlay . '"} -->';			
		$block .= '<div class="wp-block-myconianhotel-hero__content">';
		$block .= $subtitle ? '<p class="has-text-align-center">' . $subtitle . '</p>' : '';
		$block .= $header ? '<h1 class="wp-block-heading wp-myconianhotel-block-heading has-text-align-center">' . $header . '</h1>' : '';
		$block .= '</div>';
		$block .= '<!-- /wp:myconianhotel/hero -->';

		echo do_blocks( $block );			
	}
}
