<?php
/*
Template Name: Gallery page
*/
get_header();

$args = array(
    'post_type' => 'gallery',
    'posts_per_page' => -1,
);

$query = new WP_Query($args);

if ($query->have_posts()) {
    ?>
<main class="wp-block-group is-layout-flow wp-block-group-is-layout-flow has-black-background-color has-background">

	<div class="entry-content wp-block-post-content has-global-padding alignfull wp-block-post-content-is-layout-constrained">
	    <div class="masonry">
		    <?php
		    while ($query->have_posts()) {
		        $query->the_post();
		        $link = get_field('link', get_the_ID()) ?: '#';
		        
		        $featured_image = get_the_post_thumbnail(get_the_ID(), 'medium'); // Adjust size as needed
		        ?>
		        <a href="<?php echo esc_url($link) ?>" class="masonry-img-container">
		        	<?php 
			        	echo $featured_image;
			        ?>
			    </a>
		        <?php
		        // echo '<h3>' . get_the_title() . '</h3>';
		        
		    }
		    ?>
		</div>
	</div>
    <?php
}
wp_reset_postdata();

get_footer();


?>

