<?php

/**
 * Enqueue Editor assets * 
 */
add_action( 'enqueue_block_editor_assets', function(){
    $asset_file = include( __DIR__ . '/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-animation-typo',
        get_theme_file_uri() . '/theme-blocks/blocks/animation-typo/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );

    wp_localize_script(
        'myconianhotel-block-animation-typo',
        'myconianhotelBlockAnimationTypo',
        [
            'logotype' => get_option( 'myconianhotel_logotype', null ),
            'colorscheme' => get_option( 'myconianhotel_colorscheme', null )
        ]
    );
}, 100 );