<?php

/**
 * Enqueue Editor assets
 */
add_action( 'enqueue_block_editor_assets', function(){
    $asset_file = include( __DIR__ . '/build/index.asset.php' );
    $dependencies = $asset_file['dependencies'];
    wp_enqueue_script(
        'myconianhotel-block-myconianhotel-archive',
        get_theme_file_uri() . '/theme-blocks/blocks/archive/build/index.js',
        $dependencies,
        $asset_file['version'],
        true
    );
}, 100 );

/**
 * Enqueue block's PHP assets
 */
add_action('init', function(){
    register_block_type('myconianhotel/archive', array(
        'render_callback' => 'myconianhotel_render_archive_block'
    ));    
});

/**
 * myconianhotel/archive render callback
 */
function myconianhotel_render_archive_block( $attributes, $content ) {
    ob_start();
    include get_template_directory() . '/theme-blocks/blocks/archive/template.php';
    return ob_get_clean();
}
