<?php
$platformUrl = get_field( 'myconianhotel_booking_platform_url', 'option' ) ?? null;
$bookOptions = $attributes['bookOptions'] ?? null;

if ( $platformUrl && $bookOptions ) :
    ?>
<div id="bookForm" data-platform_url="<?php echo $platformUrl . '?room='; ?>" class="wp-block-myconianhotel-book-form">
    <?php if ( count( $bookOptions ) > 1 ) : ?>
    <div class="wpforms-field wpforms-field-radio">
        <fieldset>
            <legend class="wpforms-field-label"><?php echo get_field( 'myconianhotel_book_form_block_header', 'option' ) ?></legend>
            <ul>
            	<?php if ( false /*$attributes['defaultBookOption']['ID']*/ ) : ?>
                <li class="choice-1 depth-1">
                    <input type="radio" id="book-option-0" name="book-option" aria-describedby="wpforms-bookForm-field_1-description" checked value="<?php echo $attributes['defaultBookOption']['ID']; ?>" />
                    <label class="wpforms-field-label-inline" for="book-option-0"><?php echo $attributes['defaultBookOption']['label']; ?></label>
                </li>
    			<?php endif; ?>

    			<?php
    			foreach ( $bookOptions as $key => $option ) :
    				if ( $option['ID'] ) :
	    				?>
                <li class="<?php echo 'choice-' . ($key+2) . ' depth-1'?>">
                    <input type="radio" id="<?php echo 'book-option-' . ($key+2) ?>" name="book-option" aria-describedby="wpforms-bookForm-field_1-description" <?php echo 0 == $key ? 'checked' : ''; ?> value="<?php echo $option['ID']; ?>" />
                    <label class="wpforms-field-label-inline" for="<?php echo 'book-option-' . ($key+2) ?>"><?php echo $option['label']; ?></label>
                </li>
	    				<?php
	    			endif;
	    		endforeach;
	    		?>
            </ul>
            <div id="wpforms-bookForm-field_1-description" class="wpforms-field-description"><?php echo get_field( 'myconianhotel_book_form_block_description', 'option' ) ?></div>
        </fieldset>
    </div>
    <?php endif; ?>

    <div class="wp-block-myconianhotel-buttons wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">
        <div class="wp-block-button">
            <a
                href="<?php echo $platformUrl . '?room=' . $bookOptions[0]['ID']; ?>"
                class="wp-block-button__link wp-element-button"
                rel="noopener noreferrer"
                target="_BLANK"
            >
                <?php echo get_field( 'myconianhotel_book_form_block_button_text', 'option' ) ?>
            </a>            
        </div>
    </div>
</div>
    <?php
endif;
?>