(function($){

	const $blocks = $('.wp-block-myconianhotel-gallery-text.is-style-sticky.has-timeline');		
	const $values = $('.wp-block-myconianhotel-gallery-text.is-style-sticky p.has-xxlarge-font-size');

	if (! $values.length) return;

	const $timeline = $('#myconianhotel-timeline');
	//timelineValue();

	$(window).on('scroll', function() {
		if ($(window).scrollTop() > 200) {
	    	timelineValue();
		} else {
			$timeline.text('');
		}

		const elementDistanceFromBottom = ($blocks.eq(0).offset().top - $(window).scrollTop()) - $(window).height()
		const elementHeight = $blocks.eq(0).height();

		if (Math.abs(elementDistanceFromBottom) > elementHeight / 2) {
			$timeline.removeClass('is-inactive');
		} else {
			$timeline.addClass('is-inactive');			
		}
	});

	function timelineValue() {
		let closestDistance = 1000000000;
		let currentValue = '';
		
		$values.each(function(){
			const elementTop = $(this).offset().top;
	        const scrollTop = $(window).scrollTop();
	        const windowHeight = $(window).height();

	        // Position relative to the bottom of the window
	        const positionFromBottom = (elementTop - scrollTop) - windowHeight;

	        if ( positionFromBottom >= 0 && closestDistance > positionFromBottom ) {
	        	closestDistance = positionFromBottom;
	        	currentValue = $(this).text();
	        }
		});

		$timeline.text(currentValue);
	}

})(jQuery)


/*$(window).on("scroll", function () {
    let element = $(".my-element");
    let elementTop = element.offset().top; // Distance from document top
    let scrollTop = $(window).scrollTop(); // Scroll position from top
    let windowHeight = $(window).height(); // Viewport height

    let distanceFromBottom = (elementTop - scrollTop) - windowHeight;

    console.log("Distance from bottom:", distanceFromBottom);
});
*/