// https://chatgpt.com/c/6710fc20-431c-8003-b89e-15139ffebbec

const { registerBlockType } = wp.blocks;
const { __ } = wp.i18n;
const { InnerBlocks, MediaPlaceholder, BlockControls, MediaUpload, useBlockProps, useInnerBlocksProps } = wp.blockEditor;
const { ToolbarButton, ToolbarGroup } = wp.components;
const { useDispatch, useSelect } = wp.data;
const { createBlock } = wp.blocks;
import { IconSet } from '../../modules';

//*1 const { useEffect } = wp.element;

registerBlockType('myconianhotel/gallery', {
    apiVersion: 2,
    title: __('Gallery (M)', 'myconianhotel'),
    icon: IconSet.gallery,
    category: 'media',
    supports: {
        html: false
    },
    attributes: {
        backgroundColor: { // supports
            type: 'string',
            default: 'black'
        },
        align: { // supports
            type: 'string',
            default: 'full'
        },
        layout: { // supports
            type: 'string',
            default: 'constrained'
        },
        aspectRatio: { // init value for myconianhotel/media
            type: 'string',
            default: '4/3'
        },
        sliderTheme: {
            type: 'string',
            default: 'default'
        },
        style: {
            type: 'string',
            default: ''
        }
    },
    edit(props) {
        const { clientId, attributes/*1, setAttributes*/ } = props;

        //*1 TODO: Check if nedded (propably not)
        /*1useEffect(() => {
            setAttributes({ sliderTheme: attributes.sliderTheme });            
        }, [attributes.sliderTheme]);*/

        const blockProps = useBlockProps({
            className: [
                attributes.style ? `has-${attributes.style}-style` : '',
                `has-${attributes.backgroundColor}-background-color has-background`, // Background classes
                attributes.align ? `align${attributes.align}` : 'none', // Align classes
                attributes.layout ? `is-layout-${attributes.layout} has-global-padding` : '' // Layout classes
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        const innerBlocksProps = useInnerBlocksProps({
            className: [
                'wp-block-myconianhotel-gallery__preview',
                attributes.sliderTheme ? `owl-theme-${attributes.sliderTheme}` : ''
            ]}, {
            allowedBlocks: ['myconianhotel/media'],
            templateLock: false
        });

        const { replaceInnerBlocks, insertBlocks } = useDispatch('core/block-editor');

        const innerBlocks = useSelect(select => select('core/block-editor').getBlocks(clientId), [clientId]);

        // Get first 4 blocks for preview
        const previewBlocks = innerBlocks.slice(0, 4);
        const otherBlocks = innerBlocks.slice(4);

        const onSelectImages = (media) => {
            const imageBlocks = media.map((image) =>
                createBlock('myconianhotel/media', {
                    mediaId: image.id,
                    mediaUrl: image.url,
                    mediaAlt: image.alt,
                    mediaSizeSlug: 'medium',
                    mediaOrientation: image.sizes.full.height > image.sizes.full.width ? 'portrait' : 'landscape',
                    aspectRatio: attributes.aspectRatio
                })
            );
            replaceInnerBlocks(clientId, imageBlocks, false);
        };

        const onAddImages = (media) => {
            const imageBlocks = media.map((image) =>
                createBlock('myconianhotel/media', {
                    mediaId: image.id,
                    mediaUrl: image.url,
                    mediaAlt: image.alt,
                    mediaSizeSlug: 'medium',
                    mediaOrientation: image.sizes.full.height > image.sizes.full.width ? 'portrait' : 'landscape',
                    aspectRatio: attributes.aspectRatio
                })
            );
            insertBlocks(imageBlocks, innerBlocks.length, clientId);
        };

        return (
            <div {...blockProps}>
                <BlockControls>
                    <MediaUpload
                        onSelect={onAddImages}
                        allowedTypes={['image']}
                        multiple
                        render={({ open }) => (
                            <ToolbarGroup>
                                <ToolbarButton
                                    label={__('Add', 'myconianhotel')}
                                    onClick={open}
                                >
                                    {__('Add', 'myconianhotel')}
                                </ToolbarButton>
                            </ToolbarGroup>
                        )}
                    />
                </BlockControls>

                {/* Show placeholder if there are no inner blocks */}
                {!innerBlocks.length && (
                    <MediaPlaceholder
                        onSelect={onSelectImages}
                        allowedTypes={['image']}
                        multiple
                        gallery
                        labels={{ title: __('Select Images', 'myconianhotel') }}
                    />
                )}

                {/* Display the rest of the gallery */}
                {innerBlocks.length > 0 && (
                    <div className={'wp-block-myconianhotel-gallery__preview-wrap'}>
                        <div {...innerBlocksProps}></div>                        
                    </div>
                )}
            </div>
        );
    },
    save(props) {
        const { attributes } = props;

        const blockProps = useBlockProps.save({
            className: [
                attributes.style ? `has-${attributes.style}-style` : '',
                `has-${attributes.backgroundColor}-background-color has-background`, // Background classes
                attributes.align ? `align${attributes.align}` : 'none', // Align classes
                attributes.layout ? `is-layout-${attributes.layout} has-global-padding` : '' // Layout classes
            ].filter(Boolean).join(' ') // Filter out empty class values
        });
        
        const innerBlocksProps = useInnerBlocksProps.save({
            className: [
                `wp-block-myconianhotel-gallery__slider ${attributes.sliderTheme ? 'owl-carousel' : ''}`,
                attributes.sliderTheme ? `owl-theme-${attributes.sliderTheme}` : ''
            ].filter(Boolean).join(' ') // Filter out empty class values            
        });

        return (
            <div {...blockProps}>
                <div {...innerBlocksProps}></div>
            </div>
        );
    },
});