// https://chatgpt.com/c/670e1c68-d7ac-8003-b969-473442efffd7

const { __ } = wp.i18n;

const { registerBlockType } = wp.blocks;
const { InspectorControls, BlockControls, useBlockProps, InnerBlocks, useInnerBlocksProps } = wp.blockEditor;
const { Button, PanelBody, RangeControl } = wp.components;
const { Fragment, useEffect, useState } = wp.element;
const { useSelect, dispatch, select } = wp.data;

import MediaAttributes from '../../media/src/attributes';
import { MediaEdit, MediaSave, MediaUploadMedia, PanelBodyMedia } from '../../media/src/components';
import { IconSet } from '../../modules';

const updatedMediaAttributes = {
    ...MediaAttributes,
    mediaSizeSlug: {
        ...(MediaAttributes.mediaSizeSlug || {}), // Fallback to an empty object if undefined
        default: 'large',
    },
};

const TEMPLATE = [
    ['myconianhotel/paragraph', {
        textAlign: 'center',
        placeholder: __('Subtitle', 'myconianhotel')
    }],
    ['myconianhotel/heading', {
        level: 1,
        textAlign: 'center',
        placeholder: __('Heading', 'myconianhotel'),
        fontSize: 'xxlarge' // TODO
    }]
];

registerBlockType('myconianhotel/hero', {
    apiVersion: 2,
    title: __('Hero!', 'myconianhotel'),
    icon: IconSet.hero,
    category: 'layout',
    attributes: {
        ...updatedMediaAttributes,
        overlay: {
            type: 'number',
            default: .25 // If changes, must be updated in theme-blocks/blocks/hero/template.php
        }
    },
    supports: {
        media: true        
    },
    edit: (props) => {
        const { attributes, setAttributes, clientId } = props;
        const {
            overlay,
            mediaType,
            mediaId,
            mediaUrl,
            mediaAlt,
            mediaSizeSlug,
            aspectRatio,
            autoplay,
            loop,
            muted,
            controls,
            playsinline,
            preload,
            poster,
            posterId
        } = attributes;

        const [localoverlay, setLocaloverlay] = useState(overlay);

        useEffect(() => {
            // Update aspectRatio attribute
            setAttributes({ aspectRatio: '16/9' })
        }, []);

        useEffect(() => {
            updateoverlay(localoverlay);
        }, [localoverlay]);

        const postType = useSelect( ( select ) => {
            return select( 'core/editor' ).getCurrentPostType();
        }, [] );
        
        const blockProps = useBlockProps({
            className: `has-global-padding alignfull${mediaId ? ' has-media' : ''}`
        });

        const innerBlocksProps = useInnerBlocksProps({
            className: 'wp-block-myconianhotel-hero__content is-layout-flow'
        }, {
            template: TEMPLATE,
            templateLock: 'all',
            allowedBlocks: []        
        });

        const handleSliderChange = (newOverlay) => {
            setLocaloverlay(newOverlay);
        };

        const updateoverlay = (newOverlay) => {
            setAttributes({ overlay: newOverlay });
        }

        // Snipet to update existing blocks
        // Change paragraph's font size to medium-large
        useEffect(() => {
            const innerBlocks = select('core/block-editor').getBlocks(clientId);
            const paragraphBlock = innerBlocks.find(block => block.name === 'myconianhotel/paragraph');
            if ('medium-large' == paragraphBlock?.attributes?.fontSize) {
                dispatch('core/block-editor').updateBlockAttributes(paragraphBlock?.clientId, {
                    fontSize: 'medium'
                });                
            }
        }, [clientId]);

        return (
            <Fragment>
                <BlockControls>
                    <MediaUploadMedia
                        mediaId={mediaId}
                        setAttributes={setAttributes}
                    />
                </BlockControls>
                <InspectorControls>
                    <PanelBody title={__('Settings', 'myconianhotel')}>
                        <RangeControl
                            label={__('overlay opacity', 'myconianhotel')}
                            value={localoverlay}
                            onChange={handleSliderChange}
                            min={0}
                            max={.5}
                            step={.05}
                        />
                    </PanelBody>
                    <PanelBodyMedia
                        {...props.attributes}
                        setAttributes={setAttributes}
                    />
                </InspectorControls>
                <div {...blockProps}>

                    {/* Invisible editable field to focus on Editor's Blocks list */}                    
                    <textarea style={{ border: '0',clip: 'rect(1px, 1px, 1px, 1px)',clipPath: 'inset(50%)',height: '1px',margin: '-1px',overflow: 'hidden',padding: '0',position: 'absolute',width: '1px',wordWrap: 'normal' }} />                

                    <div className="wp-block-myconianhotel-hero__top"></div>
                    <MediaEdit
                        {...props.attributes}
                        setAttributes={setAttributes}
                    />
                    <div {...innerBlocksProps}></div>
                    <div className="wp-block-myconianhotel-hero__bottom is-layout-constrained">
                        { postType !== 'accommodation' && (
                            <div className="wp-block-myconianhotel-booking">Booking module</div>
                        )}
                    </div>
                    <div
                        className="wp-block-myconianhotel-hero__overlay"
                        style={{
                            opacity: overlay
                        }}
                        >                            
                    </div>
                </div>
            </Fragment>
        );
    },
    save: (props) => {
        const innerBlocksProps = useInnerBlocksProps.save({
            className: 'wp-block-myconianhotel-hero__content is-layout-flow'
        });

        return (
            <div {...innerBlocksProps}></div>
        );
    },
});
