<?php

if ( ! empty( $attributes['mediaId'] ) ) :
    $aspectRatio = $attributes['aspectRatio'] ?? '16/9';
    $overlay = $attributes['overlay'] ?? '.25'; // Default value from theme-blocks/blocks/hero/src/index.js
    $mediaType = $attributes['mediaType'] ?? 'image';
    $addVerticalPositioning = myconianhotel_block_vertical_position( $attributes['mediaOrientation'] ?? false, $attributes['originalAspectRatio'] ?? false, $attributes['aspectRatio'] ?? false );

    $style = isset( $attributes['mediaCustomPosition'] ) && $attributes['mediaCustomPosition'] >= 0 && $attributes['mediaCustomPosition'] !== 50 ? 'object-position: ' . ($addVerticalPositioning ? '50% ' : '') . $attributes['mediaCustomPosition'] . '%' . ( ! $addVerticalPositioning ? ' 50%' : '') . ';' : '';
    $style .= $attributes['aspectRatio'] ?? false && $attributes['aspectRatio'] ? 'aspect-ratio:' . $attributes['aspectRatio'] . ';' : '';
    ?>

    <div class="wp-block-myconianhotel-hero has-global-padding alignfull">
        <div class="wp-block-myconianhotel-hero__top"></div>

        <?php echo $content; ?>

        <?php
        if ( 'video' == $mediaType ) :
            // Default video related values from theme-blocks/blocks/media/attributes.js
            $autoplay = $attributes['autoplay'] ?? true;
            $loop = $attributes['loop'] ?? true;
            $muted = $attributes['muted'] ?? true;
            $controls = $attributes['controls'] ?? false;
            $playsinline = $attributes['playsinline'] ?? true;
            $preload = $attributes['preload'] ?? 'metadata';
            ?>

        <figure class="wp-block-video wp-block-myconianhotel-media wp-block-myconianhotel-video size-full">
            <video
                src="<?php echo wp_get_attachment_url( $attributes['mediaId'] ); ?>"

                <?php echo $autoplay ? 'autoplay' : '' ?>
                <?php echo $loop ? 'loop' : '' ?>
                <?php echo $muted ? 'muted' : '' ?>
                <?php echo $controls ? 'controls' : '' ?>
                <?php echo $playsinline ? 'playsinline' : '' ?>
                preload="<?php echo $preload; ?>"
                <?php echo $attributes['poster'] ? 'poster="' . $attributes['poster'] . '"' : '' ?>

                <?php if ( $aspectRatio ) : ?>
                style="<?php echo $style; ?>;object-fit:cover;">                    
                <?php endif; ?>
            </video>
        </figure>

            <?php
        else:
        ?>

        <figure class="wp-block-image wp-block-myconianhotel-media wp-block-myconianhotel-image size-full" >
            <?php echo wp_get_attachment_image( $attributes['mediaId'], 'full', false, array( 'style' => $style ) ); ?>
        </figure>
        
        <?php endif; ?>

        <div class="wp-block-myconianhotel-hero__bottom is-layout-constrained">
            <?php

            if ( ! is_singular( 'accommodation' ) && ! is_singular( 'position' ) ) {
                get_template_part( 'template-parts/booking' );
            }
            ?>
        </div>

        <div class="wp-block-myconianhotel-hero__overlay" style="opacity:<?php echo $overlay; ?>"></div>
    </div>

    <?php
endif;
?>