const { __ } = wp.i18n;
const { registerBlockType, unregisterBlockStyle, createBlock } = wp.blocks;
const { useBlockProps, useInnerBlocksProps } = wp.blockEditor;
import { IconSet } from '../../modules';

registerBlockType('myconianhotel/hotels', {
    apiVersion: 2,
    title: __('Hotels', 'myconianhotel'),
    description: __('Some description'),
    icon: IconSet.hotels,
    category: 'widgets',
    edit(props) {
        const apiRoot = window.wpApiSettings?.root; // e.g., https://example.com/wp-json/
        const siteUrl = apiRoot?.replace(/\/wp-json\/?$/, ''); // Remove `/wp-json/`

        return (
            <div class="wp-block-myconianhotel-hotels has-lightergray-background-color has-background alignfull has-global-padding" style={{justifyContent:'center', alignItems:'center'}}>
                <div class="is-layout-flow">
                    <h2 class="has-text-align-center">Hotels</h2>
                    <p class="has-text-align-center">Last update on<br/>{props.attributes.lastUpdate}<br/><br/><a href={siteUrl + '/wp-admin/options-general.php?page=myconianhotel-settings-options'} target="_blank">Force update</a></p>
                </div>
            </div>
        );
    },
    save(props) {
        return null; // Server side render
    }
});