<?php

$colorscheme = get_option( 'myconianhotel_colorscheme' );

$feed = myconianhotel_fetch_block_data(
	'https://myconiancollection.gr/wp-json/custom/v1/hotels',
    'myconianhotel_hotels_block_data',
    DAY_IN_SECONDS
);

$hotels_list = '';
$term_list = '';
$term_text = '';
$term_array = [];
$hotels_images_list = '';

$term = 'type';
$hotel_block_link = array(
	'name' => 'Hotels & Resorts',
	'url' => $feed['collection']['hotel_post_type_archive_link'] ?? null,
	'target' => 'target="_blank"'
);

if ( 'collection' == $colorscheme ) {
	$term = 'location';
	$hotel_block_link = array(
		'name' => 'Hotels & Resorts', // TODO: dynamic
		'url' => get_post_type_archive_link( 'hotel' ),
		'target' => ''
	);
}

if ( $feed['hotels'] ?? false ) {
	foreach ( $feed['hotels'] as $key => $hotel ) {
		$hotels_list .= '<a href="' . $hotel['hotel_url'] . '" class="hotel" data-location="' . $hotel[$term]['id'] . '" data-hotel="' . $hotel['id'] . '" target="blank">' . $hotel['title'] . ( $key+1 < count( $feed['hotels'] ) ? ',&nbsp;' : '' ) . '</a>';

		$hotels_images_list .= '<figure class="wp-block-myconianhotel-media wp-block-myconianhotel-image wp-block-image has-landscape-image" data-hotel="'.$hotel["id"].'"><img class="hotel-image" src="'.$hotel['featured_image'].'"></figure>';
		if ( ! in_array( $hotel[$term]['id'], $term_array ) ) {
				if ( 'collection' == $colorscheme ) {
					$term_list .= '<a href="' . $hotel[$term]['link'] . '" class="location" data-location="'.$hotel[$term]['id'].'">' . $hotel[$term]['name'] . '</a>';
				} else {
					$term_list .= '<div class="location" data-location="'.$hotel[$term]['id'].'">' . $hotel[$term]['name'] . '</div>';
				}
				
				
				$term_text .= '<div class="text" data-location="'.$hotel[$term]['id'].'">'.$hotel[$term]['description'].'</div>';
				array_push($term_array, $hotel[$term]['id']);
		}
	}
	?>

	<div class="wp-block-myconianhotel-hotels has-lightergray-background-color has-background has-gray-color has-color alignfull has-global-padding">
		<div class="hotels-locations is-layout-constrained">
			<div class=" locations-wrapper">
				<?php echo $term_list ?>
				<div class="location-text">
					<?php echo $term_text ?>
				</div>
			</div>
			
		</div>
		<div class="hotels-cetner-panel ">
			<div class="is-layout-constrained">
				<div class="hotel-images">
					<?php echo $hotels_images_list ?>
				</div>
			</div>
			<?php if ( $hotel_block_link['url'] && $hotel_block_link['name'] ) : ?>
			<a class="hotel-wording has-uppercase-text-transform" href="<?php echo $hotel_block_link['url']; ?>"<?php echo $hotel_block_link['target']; ?>><?php echo $hotel_block_link['name']; ?></a>
			<?php endif; ?>
		</div>
		<div class="hotels-list ">
			<?php echo $hotels_list ?>
		</div>
	</div>

	<?php
}