(function($) {
	var lastX = 0;
	var lastY = 0;

	var timestamp = null;
	var lastMouseX = null;
	var lastMouseY = null;

    $('.wp-block-myconianhotel-interactive-typo').on('mousemove', function(e) {
        const $circle = $('.wp-block-myconianhotel-interactive-typo .inner-circle');
        const containerOffset = $(this).offset();
        
        const mouseX = e.pageX - containerOffset.left;
        const mouseY = e.pageY - containerOffset.top;

        lastX = e.pageX;

        if (timestamp === null) {
        timestamp = Date.now();
        lastMouseX = e.screenX;
        lastMouseY = e.screenY;
        return;
	    }

	    var now = Date.now();
	    var dt =  now - timestamp;
	    var dx = e.screenX - lastMouseX;
	    var dy = e.screenY - lastMouseY;
	    var speedX = Math.round(dx / dt * 100);
	    var speedY = Math.round(dy / dt * 100);

	    timestamp = now;
	    lastMouseX = e.screenX;
	    lastMouseY = e.screenY;
       
        var windowMin = 0;
        var windowMax = $(window).width();
        var rotateMin = -100;
        var rotateMax = 100;

        function rotateNum (number, inMin, inMax, outMin, outMax) {
		    return (number - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
		}

		var degrees = rotateNum(e.pageX, windowMin, windowMax, rotateMin, rotateMax)

		$circle.css({
            left: `${mouseX}px`,
            top: `${mouseY}px`,
        });

        $('.wp-block-myconianhotel-interactive-typo .inner-wrapper').css({
        	transform: `rotate(${degrees}deg)`
        })

    });
})(jQuery)