
(function($){

	$(document).ready(function() {
		const inactiveColor = 'has-darkgray-background-color';

		$('.wp-block-myconianhotel-media-text-slide').each(function(){
			$(this).attr('data-active_bg', getBgColorClass($(this), 0));
			$(this).attr('data-inactive_bg', getBgColorClass($(this), 1));
			$(this).attr('data-inactive_color', getColorClass($(this), 1));
		});

		$('.wp-block-myconianhotel-media-text-slide .wp-block-myconianhotel-media-text').on('click', function() {
			if ($(this).hasClass('is-active') || window.innerWidth < 1200) return;

			const activeBg = $(this).closest('.wp-block-myconianhotel-media-text-slide').data('active_bg');
			const inactiveBg = $(this).closest('.wp-block-myconianhotel-media-text-slide').data('inactive_bg');
			const inactiveColor = $(this).closest('.wp-block-myconianhotel-media-text-slide').data('inactive_color') + ' has-color';

			console.log('inactiveColor: ' + inactiveColor);
			console.log('inactiveBg: ' + inactiveBg);
			console.log('------');

			let index = [0,1]
			$(this).closest('.wp-block-myconianhotel-media-text-slide').toggleClass('slide');
			$(this).closest('.wp-block-myconianhotel-media-text-slide').find('.wp-block-myconianhotel-media-text').removeClass('is-active');
			$(this).toggleClass('is-active');

			if ($(this).closest('.wp-block-myconianhotel-media-text-slide').hasClass('slide')) {
				index = [1,0]
			}

			$('.wp-block-myconianhotel-media-text-slide .wp-block-myconianhotel-media-text').eq(index[0])?.removeClass(inactiveBg).removeClass(inactiveColor).addClass(activeBg);
			$('.wp-block-myconianhotel-media-text-slide .wp-block-myconianhotel-media-text').eq(index[1])?.removeClass(activeBg).addClass(inactiveColor).addClass(inactiveBg);

		});
	});

	function getBgColorClass($this, index) {
		return $this.closest('.wp-block-myconianhotel-media-text-slide').find('.wp-block-myconianhotel-media-text')?.eq(index)?.attr('class').split(' ').find(cls => 
			cls.startsWith('has-') && cls.endsWith('-background-color')
		);
	}

	function getColorClass($this, index) {
		return $this.closest('.wp-block-myconianhotel-media-text-slide').find('.wp-block-myconianhotel-media-text')?.eq(index)?.attr('class').split(' ').find(cls => 
			cls.startsWith('has-') && cls.endsWith('-color') && cls.indexOf('background') === -1
		);
	}

})(jQuery)