const { registerBlockType } = wp.blocks;
const { useState } = wp.element;
const { Button } = wp.components;
const { InnerBlocks, useBlockProps, useInnerBlocksProps } = wp.blockEditor;
const { __ } = wp.i18n;
import { IconSet } from '../../modules';

const TEMPLATE = [
    ['myconianhotel/media-text', {mediaPosition: 'right', isMediaTextSlide: true, aspectRatio: '1/1', backgroundColor: 'white', hasMediaPositionOption: false, extraClassName: 'is-active'}],
    ['myconianhotel/media-text', {mediaPosition: 'right', isMediaTextSlide: true, aspectRatio: '1/1', backgroundColor: 'darkgray', hasMediaPositionOption: false, extraClassName: 'has-lightbrown-color has-color'}]
];

registerBlockType('myconianhotel/media-text-slide', {
    apiVersion: 2, // Use block API version 2
    title: __('Media & Text Slide', 'myconianhotel'),
    icon: IconSet.mediaTextSlide,
    category: 'layout',
    attributes: {
        /*align: {
            type: 'string',
            default: 'wide',
        }*/
    },
    supports: {
        //align: ['wide', 'full'], // Optional: support alignment options
        inserter: true, // Prevents this block from appearing in the block inserter
    },
    edit: (props) => {
        const { clientId } = props;
        const [isSlideActive, setIsSlideActive] = useState(false);

        const blockProps = useBlockProps({
            className: [
                'alignfull',
                isSlideActive ? 'slide' : ''
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        const innerBlocksProps = useInnerBlocksProps({
            className: [
                'wp-block-myconianhotel-media-text-slide__wrap'
            ].filter(Boolean).join(' ') // Filter out empty class values
        }, {
            templateLock: 'delete',
            template: TEMPLATE,
            allowedBlocks: []        
        });

        // Toggle the slide class when the button is clicked
        const toggleSlideClass = () => {
            setIsSlideActive(prevState => !prevState);
        };

        return (
            <div {...blockProps}>
                <Button 
                    className="components-button is-primary "                    
                    onClick={toggleSlideClass}
                >
                    Toggle between slides
                </Button>
                <div {...innerBlocksProps}></div>
            </div>
        );
    },
    save: () => {
        const blockProps = useBlockProps.save({
            className: [
                'alignfull'
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        const innerBlocksProps = useInnerBlocksProps.save({
            className: [
                'wp-block-myconianhotel-media-text-slide__wrap'
            ].filter(Boolean).join(' ') // Filter out empty class values
        }, {
            templateLock: 'delete',
            template: TEMPLATE,
            allowedBlocks: []        
        });

        return (
            <div {...blockProps}>
                <div {...innerBlocksProps}></div>
            </div>
        );
    },
});
