const { __ } = wp.i18n;

const {
    InnerBlocks,
    useInnerBlocksProps,
    useBlockProps
} = wp.blockEditor;

const TEMPLATE = [
    ['myconianhotel/paragraph', {
        textAlign: 'center',
        placeholder: __('Subtitle', 'myconianhotel')
    }],
    ['myconianhotel/heading', {
        level: 2,
        textAlign: 'center',
        placeholder: __('Heading', 'myconianhotel')
    }],
    ['myconianhotel/paragraph', {
        textAlign: 'center',
        placeholder: __('Content', 'myconianhotel')
    }],
    ['myconianhotel/buttons']
];

export const MediaTextEdit = ({
    mediaType,
    mediaUrl,
    mediaAlt,
    mediaId,
    mediaSizeSlug,
    open,
    controls,
    autoplay,
    loop,
    muted,
    playsinline,
    preload,
    poster,
    setAttributes
}) => {

    const innerBlocksProps = useInnerBlocksProps({
        className: 'wp-block-media-text__content'
    }, {
        template: TEMPLATE,
        allowedBlocks: []        
    });

    return (
        <div {...innerBlocksProps}></div>
    );
}

export const MediaTextSave = ({
    mediaType,
    mediaUrl,
    mediaAlt,
    mediaId,
    mediaSizeSlug,
    controls,
    autoplay,
    loop,
    muted,
    playsinline,
    preload,
    poster
}) => {

    return (
        <div class="wp-block-media-text__content">
            <InnerBlocks.Content />
        </div>
    );
}