// If any default value of
// autoplay
// loop
// muted
// controls
// playsinline
// preload
// is updated, must be updated in theme-blocks/blocks/hero/template.php

const MediaAttributes = {    
    mediaType: {
        type: 'string',
        default: 'image'
    },
    mediaId: {
        type: 'number',
    },
    mediaUrl: {
        type: 'string',
    },
    mediaAlt: {
        type: 'string',
        default: '',
    },
    mediaSizeSlug: {
        type: 'string',
        default: 'medium_large',
    },
    mediaOrientation: {
        type: 'string'
    },
    mediaAnchor: {
        type: 'string',
        default: ''
    },
    mediaCustomPosition: {
        type: 'number',
        default: 50
    },
    aspectRatio: {
        type: 'string',
        default: 'unset', // Default aspect ratio
    },
    originalAspectRatio: {
        type: 'number'
    },
    autoplay: {
        type: 'boolean',
        default: true
    },
    loop: {
        type: 'boolean',
        default: true
    },
    muted: {
        type: 'boolean',
        default: true
    },
    controls: {
        type: 'boolean',
        default: false
    },
    playsinline: {
        type: 'boolean',
        default: true
    },
    preload: {
        type: 'string',
        default: 'metadata'
    },
    poster: {
        type: 'string',
        default: ''
    },
    posterId: {
        type: 'number',
    },
    relatedPostsLinkOption: {
        type: 'boolean',
        default: false
    },
    relatedPosts: {
        type: 'boolean',
        default: false
    },
    experimentalLink: {
        type: 'array',
        default: []
    }
}

export default MediaAttributes;