<?php
// API credentials
$username = get_field( 'myconianhotel_booking_platform_username', 'option' ) ?? null;
$password = get_field( 'myconianhotel_booking_platform_password', 'option' ) ?? null;
$propertyCode = $username;
// $propertyCode = 'DEMO';

if ( $username && $password ) {
	// API endpoint for single-property availability
	$baseUrl = 'https://rest.reserve-online.net';
	$endpoint = "/offers/$propertyCode";
	$url = $baseUrl . $endpoint;


	// Initialize cURL
	$ch = curl_init($url);

	// Set cURL options
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return response instead of outputting
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC); // Use Basic Auth
	curl_setopt($ch, CURLOPT_USERPWD, "$username:$password"); // Set credentials
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
	    'Accept: application/json', // Request JSON format
	    'Accept-Language: en', // Optional: Set response language
	]);

	// Execute the request
	$response = curl_exec($ch);
	$responseData = null;

	// Check for errors
	if (curl_errno($ch)) {
	    echo 'cURL Error: ' . curl_error($ch);
	} else {
	    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	    if ($httpCode === 200) {
	        // Successful response
	        $responseData = json_decode($response, true);
	       
	    }
	}

	if ( $responseData && ! curl_errno($ch) ) :
		$logo_src = wp_get_attachment_image_src( get_theme_mod( 'custom_logo' ), 'full' )[0] ?? false;
		?>
		<div class="wp-block-myconianhotel-archive is-style-zebra has-global-padding is-layout-constrained alignfull">
			<?php
			foreach ($responseData['data']['offers'] as $offer) :


				if ( $offer['display'] ) :
					$start_date = date_create($offer['fromd']); 
					$end_date = date_create($offer['tod']); 
			    ?>

		    <div class="wp-block-myconianhotel-post wp-block-myconianhotel-group wp-block-group is-layout-constrained alignfull has-global-padding">	
				<div class="wp-block-myconianhotel-media-text wp-block-media-text is-stacked-on-mobile has-media-on-the-right">
					<figure class="wp-block-media-text__media">
						<?php if ( $offer['photourlM'] ) : ?>
						<img width="1024"
							 height="512"
							 src="<?php echo $offer['photourlL'] ?>"
							 class="attachment-large size-large wp-post-image"
							 alt=""
							 style="aspect-ratio:3/2;object-fit:cover;"
							 decoding="async"
							 fetchpriority="high"
							 srcset="<?php echo $offer['photourlL'] ?> 1024w, <?php echo $offer['photourlM'] ?> 300w"
							 sizes="(max-width: 1024px) 100vw, 1024px">	
						<?php
						else :
							get_template_part( 'template-parts/image', 'placeholder', array( 'src' => $logo_src, 'aspectRatio' => '3/2' ) );	
						endif;
						?>
					</figure>

					<div class="wp-block-media-text__content is-layout-flow">						

						<h2 class="wp-block-heading wp-myconianhotel-block-heading"><?php echo $offer['name'] ?></h2>
						<p class="is-style-subtitle"><?php echo $offer['description'] ?></p>
						<p><span class="has-small-font-size has-uppercase-text-transform">Minimum stay</span><br><?php echo $offer['min_stay'] ?> <?php echo $offer['min_stay'] > '1' ? 'nights' : 'night' ?></p>
						<p><span class="has-small-font-size has-uppercase-text-transform">Stay Period</span><br><?php echo date_format($start_date,"d M Y").' - '.date_format($end_date,"d M Y"); ?></p>
						<p>from <span class="has-large-font-size">€<?php echo $offer['min_price'] ?></span> per night</p>

						<div class="wp-block-myconianhotel-buttons wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">
							<div class="wp-block-button">
								<a class="wp-block-button__link wp-element-button" target="blank" href="<?php echo $offer['bookurl'] ?>">BOOK NOW</a>
							</div>
						</div>
					</div>
				</div>
			</div>

			    <?php
			    endif;	
		   endforeach;
		   ?>
		</div>
		<?php
		// Close cURL
		curl_close($ch);
	else:
	?>

	<div class="wp-block-myconianhotel-free-text wp-block alignfull is-layout-constrained has-global-padding is-style-presetMediaTextXxlarge has-default-background-color has-background-color">
		<div class="is-layout-flow">
			<p class="has-text-align-center has-xxlarge-font-size">At this time, we do not have any special offers available</p>
			<div class="wp-block-myconianhotel-buttons wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">
				<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="<?php echo get_home_url(); ?>">Return to the homepage</a></div>
			</div>
		</div>
	</div>

	<?php
	endif;

} else {
	?>

	<div class="wp-block-myconianhotel-free-text wp-block alignfull is-layout-constrained has-global-padding is-style-presetMediaTextXxlarge has-default-background-color has-background-color">
		<div class="is-layout-flow">
			<p class="has-text-align-center has-xxlarge-font-size">At this time, we do not have any special offers available</p>
			<div class="wp-block-myconianhotel-buttons wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">
				<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="<?php echo get_home_url(); ?>">Return to the homepage</a></div>
			</div>
		</div>
	</div>

	<?php
}