// https://chatgpt.com/c/670cd370-42a4-8003-a6cc-ab8432f4e1fd

const { registerBlockType } = wp.blocks;
const { RichText, useBlockProps, BlockControls, AlignmentToolbar, InspectorControls } = wp.blockEditor;
const { PanelBody, SelectControl } = wp.components;
const { RawHTML } = wp.element;
const { __ } = wp.i18n;

registerBlockType('myconianhotel/paragraph', {
    apiVersion: 2,
    title: __('Paragraph (M)', 'myconianhotel'),
    category: 'common',
    icon: 'editor-paragraph',
    supports: {
        textAlign: true,
        inserter: true, // Allows this block to appear in the block inserter
    },
    attributes: {
        text: {
            type: 'string'
        },
        placeholder: {
            type: 'string',
            default: __('Type', 'myconianhotel')
        },
        textAlign: {
            type: 'string',
            default: 'left' // Default alignment is left
        },
        fontSize: {
            type: 'string',
            default: ''
        },
        allowTransform: {
            type: 'bool',
            default: true
        },
        tag: {
            type: 'string',
            default: 'p'
        },
        className: {
            type: 'string',
            default: ''
        }
    },
    edit({ attributes, setAttributes }) {
        const { text, textAlign, placeholder, fontSize, tag, className } = attributes;

        const onChangeText = (newText) => {
            setAttributes({ text: newText });
        };

        const onChangeAlignment = (newAlignment) => {
            setAttributes({ textAlign: newAlignment || 'left' });
        };

        const blockProps = useBlockProps();        

        return (
            <>
                {/*<BlockControls>
                    <AlignmentToolbar
                        value={textAlign}
                        onChange={onChangeAlignment}
                    />
                </BlockControls>*/}
                <InspectorControls>
                    <PanelBody title="Options">
                        <SelectControl
                            label="Transform to"
                            value={tag} // The currently selected option
                            options={[
                                { label: 'Paragraph', value: 'p' },
                                { label: 'Blockquote', value: 'blockquote' },
                            ]}
                            onChange={(value) => setAttributes({tag: value})}
                        />
                    </PanelBody>
                </InspectorControls>

                <RichText
                    {...blockProps}
                    tagName={tag}
                    value={text}
                    onChange={onChangeText}
                    placeholder={placeholder}
                    className={`${'center' === textAlign ? 'has-text-align-center' : ('right' === textAlign ? 'has-text-align-right' : '')}${fontSize ? ` has-${fontSize}-font-size` : ''}${className ? ' ' + className : ''}`}
                />
            </>
        );
    },
    save({ attributes }) {
        const { text, textAlign, fontSize, tag, className } = attributes;                
        const  classes = `${'center' === textAlign ? 'has-text-align-center' : ('right' === textAlign ? 'has-text-align-right' : '')}${fontSize ? ` has-${fontSize}-font-size` : ''}${className ? ' ' + className : ''}`;

        return React.createElement(tag, { className: classes || undefined }, text && <RawHTML>{text}</RawHTML>);
    }
});
