const { registerBlockType } = wp.blocks;
const { useBlockProps } = wp.blockEditor;
const { useState, useEffect } = wp.element;
const { select } = wp.data;
const { __ } = wp.i18n;
import { IconSet } from '../../modules';

registerBlockType('myconianhotel/post-acf-fields', {
    apiVersion: 2,
    title: 'ACF post fields',
    category: 'widgets',
    icon: IconSet.postAcfFields,

    edit: (props) => {
        const { attributes, setAttributes } = props;
        const blockProps = useBlockProps({
            className: 'wp-block is-layout-flow'
        });

        // Parse attributesHelper from attributes
        const attributesHelper = JSON.parse(attributes.attributesHelper || '{}');
        const [acfValues, setAcfValues] = useState(JSON.parse(attributes.acfValues || '{}'));

        useEffect(() => {
            // Fetch ACF values from the post meta
            const meta = select('core/editor').getEditedPostAttribute('acf');
            const initialValues = meta?.myconian_room_attributes || {};

            // Update acfValues state and attributes
            setAcfValues(initialValues);
            setAttributes({ acfValues: JSON.stringify(initialValues) }); // Persist to attributes
        }, []);

        return (
            <div {...blockProps}>
                <p>{__('Details', 'myconianhotel')}</p>
                <ul>
                    {
                      Object.entries(acfValues).some(([key, value]) => value != '') ? (
                        Object.entries(acfValues).map(([key, value]) => 
                          value && (
                            <li key={key}>
                              {((attributesHelper[key]?.choices?.[value] ?? value) + ' ' + (value == 1 ? attributesHelper[key]?.after_value_singular : attributesHelper[key]?.after_value)) || __('Not set', 'myconianhotel')}
                            </li>
                          )
                        )
                      ) : (
                        <li>{__('Add Attributes from the right sidebar', 'myconianhotel')}</li>
                      )
                    }
                </ul>
            </div>
        );
    },
    save: (props) => {



        return null; // server side render



        const blockProps = useBlockProps.save({
            className: 'wp-block is-layout-flow'
        });
        const attributesHelper = JSON.parse(props.attributes.attributesHelper || '{}');
        const acfValues = JSON.parse(props.attributes.acfValues || '{}'); // Parse stored ACF values

        return (
            <div {...blockProps}>
                <p>{__('Details', 'myconianhotel')}</p>
                <ul>
                    {Object.entries(acfValues).map(([key, value]) => (
                        value && (
                            <li key={key}>{((attributesHelper[key]?.choices?.[value] ?? value) + ' ' + attributesHelper[key]?.after_value) || __('Not set', 'myconianhotel')}</li>
                        )
                    ))}
                </ul>
            </div>
        );
    }
});

// https://chatgpt.com/c/6740c8cb-c95c-8003-a808-f86be58ee231
/*const { useState, useEffect } = wp.element;
const { registerBlockType } = wp.blocks;
const { useSelect, dispatch, select } = wp.data;
const { useBlockProps } = wp.blockEditor;
const { __ } = wp.i18n;

registerBlockType('myconianhotel/post-acf-fields', {
    apiVersion: 2,
    title: 'Custom ACF Block',
    category: 'widgets',
    icon: 'admin-post',
    edit: (props) => {
        const blockProps = useBlockProps();
        const [acfValues, setAcfValues] = useState({});
        const roomAttributes = JSON.parse(props.attributes.roomAttributes); // Parse JSON to an array

        useEffect(() => {
            // Get the initial values for all keys in `myconian_room_attributes`
            const meta = select('core/editor').getEditedPostAttribute('acf');
            const initialAttributes = meta?.myconian_room_attributes || {};

            setAcfValues(initialAttributes);

            // Add listeners for each key in `myconian_room_attributes`
            const attributeKeys = Object.keys(initialAttributes);
            const inputListeners = [];

            attributeKeys.forEach((key) => {
                // Handle text, radio, and checkbox inputs
                const acfInput = document.querySelector(`[data-name="myconian_room_attributes"] [data-name="${key}"]`);
                if (acfInput) {
                    const inputs = acfInput.querySelectorAll('input'); // Select all inputs within the ACF field

                    inputs.forEach((input) => {
                        const updateMeta = () => {
                            let newValue;
                            if (input.type === 'checkbox') {
                                // For checkboxes, collect all checked values
                                const checkedValues = Array.from(inputs)
                                    .filter((checkbox) => checkbox.checked)
                                    .map((checkbox) => checkbox.value);
                                newValue = checkedValues;
                            } else if (input.type === 'radio') {
                                // For radio buttons, get the selected value
                                newValue = inputs.length
                                    ? Array.from(inputs).find((radio) => radio.checked)?.value || ''
                                    : '';
                            } else {
                                // Default to input value for other types (e.g., text)
                                newValue = input.value;
                            }

                            setAcfValues((prevValues) => ({
                                ...prevValues,
                                [key]: newValue,
                            }));

                            // Update Gutenberg meta state
                            dispatch('core/editor').editPost({
                                meta: {
                                    ...select('core/editor').getEditedPostAttribute('meta'),
                                    [key]: newValue,
                                },
                            });
                        };

                        // Attach listener to each input
                        input.addEventListener('change', updateMeta);
                        inputListeners.push({ element: input, listener: updateMeta });
                    });
                }
            });

            // Cleanup all listeners
            return () => {
                inputListeners.forEach(({ element, listener }) => {
                    element.removeEventListener('change', listener);
                });
            };
        }, []);

        return (
            <div {...blockProps}>
                <p>{__('Details', 'myconianhotel')}</p>
                <ul>
                    {Object.entries(acfValues).map(([key, value]) => (
                        <li key={key}>
                            <strong>{roomAttributes[key]?.title}:</strong> {
                                //Array.isArray(value) ? value.join(', ') : (value + ' ' + roomAttributes[key]?.after_value) || __('Not set', 'myconianhotel')
                                ( (roomAttributes[key]?.choices?.[value] ?? value) + ' ' + roomAttributes[key]?.after_value ) || __('Not set', 'myconianhotel')
                            }
                        </li>
                    ))}
                </ul>
            </div>
        );
    },
    save: () => {
        // Dynamic block: rendered via PHP
        return null;
    },
});*/