/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./blocks/modules.js":
/*!***************************!*\
  !*** ./blocks/modules.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CustomPanelColorSettings: () => (/* binding */ CustomPanelColorSettings),
/* harmony export */   IconSet: () => (/* binding */ IconSet)
/* harmony export */ });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @wordpress/element */ "@wordpress/element");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
const {
  PanelColorSettings
} = wp.blockEditor;
const {
  useSelect
} = wp.data;
const CustomPanelColorSettings = props => {
  const {
    setAttributes,
    backgroundColor,
    mediaBacgroundColor,
    palette,
    secondary
  } = props;

  // Get theme-defined palette & filter colors
  const colors = useSelect(select => {
    const settings = select('core/block-editor').getSettings();
    const allColors = settings.colors || [];

    // First, find the color value of the 'darkblue' slug
    const darkblueEntry = allColors.find(color => color.slug === 'darkblue');
    const darkblueColor = darkblueEntry?.color;
    return allColors.filter(color => {
      // Keep only if it's in the palette
      if (!palette.includes(color.slug)) return false;

      // If it's the 'darkblue' entry, keep it
      if (color.slug === 'darkblue') return true;

      // Exclude any other entry with the same color value as 'darkblue'
      return color.color !== darkblueColor;
    });
  }, []);
  if (!secondary) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PanelColorSettings, {
      title: "Color (M)",
      colorSettings: [{
        value: colors.find(c => c.slug === backgroundColor)?.color || undefined,
        onChange: newColor => {
          const matched = colors.find(c => c.color === newColor);
          setAttributes({
            backgroundColor: matched?.slug || undefined
          });
        },
        label: 'Background color',
        colors
      }]
    });
  } else {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(PanelColorSettings, {
      title: "",
      className: "custom-panel-color-settings",
      colorSettings: [{
        value: colors.find(c => c.slug === mediaBacgroundColor)?.color || undefined,
        onChange: newColor => {
          const matched = colors.find(c => c.color === newColor);
          setAttributes({
            mediaBacgroundColor: matched?.slug || undefined
          });
        },
        label: 'Background color',
        colors
      }]
    });
  }
};


const IconSet = {
  animationTypo: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M0,0v20h20V0H0ZM12.6,16.2l-1.6-3.8h-5.1s-1.6,3.7-1.6,3.7h-1.3S8.3,3.8,8.3,3.8h.9s5.3,12.4,5.3,12.4h-1.9ZM16,16.2L10.7,3.8h1l5.3,12.4h-1ZM8.4,6.5l2.2,5h-4.3s2.1-5,2.1-5Z"
    })
  }),
  archive: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.2",
      y: "2.2",
      width: "7",
      height: "7"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "3.5",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "6.5",
      width: "3",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.2",
      y: "10.8",
      width: "7",
      height: "7"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "12",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.8",
      y: "15",
      width: "3",
      height: "1.5"
    })]
  }),
  bookForm: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "5.7",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "5.7",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "8.7",
      width: "8.8",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("polygon", {
      points: "11.6 17.3 8.4 14.3 9.4 13.2 11.5 15.2 14.9 11.7 16 12.7 11.6 17.3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "2.7",
      width: "12",
      height: "1.5"
    })]
  }),
  contact: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M9.8,9.3L2,5h16l-8.2,4.3ZM9.8,11.3L2,6v9h16V6l-8.2,5.3Z"
    })
  }),
  filesText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12",
      y: "8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12",
      y: "11",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("polygon", {
      points: "8 15.6 3 15.6 3 4.4 10.5 4.4 10.5 13.1 8 15.6"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("polygon", {
      points: "6.8 12.1 6.8 14.7 9.5 12.1 6.8 12.1",
      fill: "#FFFFFF"
    })]
  }),
  freeText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "3.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "6.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "9.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "12.2",
      width: "12",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "4",
      y: "15.2",
      width: "8",
      height: "1.5"
    })]
  }),
  gallery: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "5.5",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "6.5",
      width: "3.9",
      height: "7"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.1",
      y: "6.5",
      width: "3.9",
      height: "7"
    })]
  }),
  galleryText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "5.5",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "5.5",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "7.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "10.8",
      width: "5",
      height: "1.5"
    })]
  }),
  googleMap: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M14.2,11.1h0c.5-.8.8-1.7.8-2.8,0-2.8-2.2-5-5-5s-5,2.2-5,5,.3,2,.8,2.8h0,0s0,0,0,0l4.1,5.4,4.1-5.4s0,0,0,0h0ZM10,6.9c.8,0,1.5.7,1.5,1.5s-.7,1.5-1.5,1.5-1.5-.7-1.5-1.5.7-1.5,1.5-1.5Z"
    })
  }),
  hero: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M2,4.1v9h16V4.1H2ZM8.3,5.7c.8,0,1.5.7,1.5,1.5s-.7,1.5-1.5,1.5-1.5-.7-1.5-1.5.7-1.5,1.5-1.5ZM16.5,11.6H3.5s.7-1.8,2.7-2.4c2.1-.5,2,1.9,3.5,1.4,1.5-.5,2.7-5.1,4.9-4.4,2.2.7,1.8,5.3,1.8,5.3Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "5",
      y: "14.4",
      width: "10",
      height: "1.5"
    })]
  }),
  hotels: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M14.5.8h-7c-.6,0-1,.4-1,1v3H1.5c-.6,0-1,.4-1,1v7.5h8.5v-3.5c0-.1,0-.2,0-.3,0,0,0,0,0-.1,0,0,0,0,0-.1,0-.1.2-.2.3-.3.1,0,.3-.2.5-.2h5.5V1.8c0-.6-.4-1-1-1ZM5,10.8h-3v-3h3v3ZM11,6.8h-1.5v-1c0-.6-.4-1-1-1h-.5v-1h3v3Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "15",
      y: "11.2",
      width: "3",
      height: "5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.5",
      y: "11.8",
      width: "3",
      height: "3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "9",
      y: "17.8",
      width: "10.5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: ".5",
      y: "14.8",
      width: "8.5",
      height: "1.5"
    })]
  }),
  interactiveTypo: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M0,0v20h20V0H0ZM11.3,16.2l-1.6-3.8h-5.1s-1.6,3.7-1.6,3.7h-1.3S7,3.8,7,3.8h.9s5.3,12.4,5.3,12.4h-1.9ZM17.8,10.8l-1.1,1.1-2.4-2.3-1.4,2.6-3.5-8.4,8.9,3.6-2.8,1.2,2.3,2.3ZM7.1,6.5l2.2,5h-4.3s2.1-5,2.1-5Z"
    })
  }),
  masonry: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "1.8",
      width: "10",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "13.5",
      y: "1.8",
      width: "4.5",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "7.8",
      width: "16",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "13.8",
      width: "4.5",
      height: "4.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "8",
      y: "13.8",
      width: "10",
      height: "4.5"
    })]
  }),
  media: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M16.5,5.5v9H3.5V5.5h13M18,4H2v12h16V4h0Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M3.5,14.5s.7-1.8,2.7-2.4,2,1.9,3.5,1.4,2.7-5.1,4.9-4.4,1.8,5.3,1.8,5.3H3.5Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("circle", {
      cx: "8.3",
      cy: "10",
      r: "1.5"
    })]
  }),
  mediaText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1.8",
      y: "5.5",
      width: "9",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12.2",
      y: "7.8",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12.2",
      y: "10.8",
      width: "6",
      height: "1.5"
    })]
  }),
  mediaTextHero: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M20,3H0v14h20V3ZM10.2,14H2.2V6h8v8ZM17.2,12.2h-5v-1.5h5v1.5ZM12.2,9.2v-1.5h5v1.5h-5Z"
    })
  }),
  mediaTextSlide: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "0",
      y: "7.8",
      width: "5.5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "0",
      y: "10.8",
      width: "5.5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M10.5,0v5.5h-3.5v9h3.5v5.5h9.5V0h-9.5ZM17.5,12.2h-5.5v-1.5h5.5v1.5ZM17.5,9.2h-5.5v-1.5h5.5v1.5Z"
    })]
  }),
  offers: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M4.5,7.4c0-.9.2-1.5.6-2s.9-.6,1.6-.6,1.2.2,1.6.6.6,1.1.6,2-.2,1.5-.6,2-.9.6-1.6.6-1.2-.2-1.6-.6-.6-1.1-.6-2ZM6,7.4c0,.6,0,1.1.2,1.3.1.2.3.2.5.2s.4,0,.5-.2c.1-.2.2-.6.2-1.3s0-1.1-.2-1.3c-.1-.2-.3-.2-.5-.2s-.4,0-.5.2c-.1.2-.2.6-.2,1.3ZM8.1,15.2h-1.4l5.3-10.4h1.4l-5.2,10.4ZM11.1,12.6c0-.9.2-1.5.6-2s.9-.6,1.6-.6,1.2.2,1.6.6.6,1.1.6,2-.2,1.5-.6,2-.9.6-1.6.6-1.2-.2-1.6-.6-.6-1.1-.6-2ZM12.6,12.6c0,.6,0,1.1.2,1.3.1.2.3.2.5.2s.4,0,.5-.2c.1-.2.2-.6.2-1.3s0-1.1-.2-1.3c-.1-.2-.3-.2-.5-.2s-.4,0-.5.2c-.1.2-.2.6-.2,1.3Z"
    })
  }),
  postAcfFields: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "12",
      width: "16",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "15",
      width: "16",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M7.9,8.9h-1.2l-.5-1.2h-2.1l-.4,1.2h-1.1l2.1-5.3h1.1l2.1,5.3ZM5.9,6.8l-.7-2-.7,2h1.5Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M11.9,7l1,.3c-.2.6-.4,1-.8,1.3-.4.3-.8.4-1.4.4s-1.3-.2-1.7-.7-.7-1.1-.7-2,.2-1.6.7-2.1c.5-.5,1.1-.7,1.8-.7s1.2.2,1.6.6c.2.2.4.6.5,1l-1.1.3c0-.3-.2-.5-.4-.7-.2-.2-.4-.2-.7-.2s-.7.1-1,.4c-.2.3-.4.7-.4,1.4s.1,1.2.4,1.4c.2.3.6.4.9.4s.5,0,.7-.3c.2-.2.4-.5.4-.9Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M13.8,8.9V3.6h3.7v.9h-2.6v1.3h2.2v.9h-2.2v2.3h-1.1Z"
    })]
  }),
  postInfo: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "11.5",
      y: "4.8",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "11.5",
      y: "7.8",
      width: "6",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "10.8",
      width: "15",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "13.8",
      width: "15",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "16.8",
      width: "10",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.5",
      y: "1.8",
      width: "7.5",
      height: "7.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "11.5",
      y: "1.8",
      width: "6",
      height: "1.5"
    })]
  }),
  postTeaser: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "4.2",
      width: "8.2",
      height: "5.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "11.2",
      width: "8.2",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.8",
      y: "11.2",
      width: "8.2",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "14.2",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.8",
      y: "14.2",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "10.8",
      y: "4.2",
      width: "8.2",
      height: "5.5"
    })]
  }),
  postTeaserGallery: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "4",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "7.5",
      y: "14.5",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "14.5",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14",
      y: "4",
      width: "5",
      height: "9"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "7.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1",
      y: "10.8",
      width: "5",
      height: "1.5"
    })]
  }),
  weather: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "9.2",
      y: "1.5",
      width: "1.5",
      height: "3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M10,7.5c1.4,0,2.5,1.1,2.5,2.5s-1.1,2.5-2.5,2.5-2.5-1.1-2.5-2.5,1.1-2.5,2.5-2.5M10,6c-2.2,0-4,1.8-4,4s1.8,4,4,4,4-1.8,4-4-1.8-4-4-4h0Z"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "5.8",
      y: "2.4",
      width: "1.5",
      height: "3",
      transform: "translate(-1.1 3.8) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "3.2",
      y: "5",
      width: "1.5",
      height: "3",
      transform: "translate(-3.7 6.7) rotate(-60)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "1.5",
      y: "9.2",
      width: "3",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2.4",
      y: "12.8",
      width: "3",
      height: "1.5",
      transform: "translate(-6.2 3.8) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "5",
      y: "15.3",
      width: "3",
      height: "1.5",
      transform: "translate(-10.7 13.7) rotate(-60)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "9.2",
      y: "15.5",
      width: "1.5",
      height: "3"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12.8",
      y: "14.6",
      width: "1.5",
      height: "3",
      transform: "translate(-6.2 8.9) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "15.3",
      y: "12",
      width: "1.5",
      height: "3",
      transform: "translate(-3.7 20.7) rotate(-60)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "15.5",
      y: "9.2",
      width: "3",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "14.6",
      y: "5.8",
      width: "3",
      height: "1.5",
      transform: "translate(-1.1 8.9) rotate(-30)"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "12",
      y: "3.2",
      width: "3",
      height: "1.5",
      transform: "translate(3.3 13.7) rotate(-60)"
    })]
  }),
  widgetText: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("svg", {
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 20 20",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "7.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("rect", {
      x: "2",
      y: "10.8",
      width: "5",
      height: "1.5"
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("path", {
      d: "M9.8,14.2l-2.2-8.4h1.8l1.3,5.5,1.2-5.5h1.8l1.2,5.5,1.3-5.5h1.8l-2.2,8.4h-1.7l-1.2-5.4-1.2,5.4h-1.8Z"
    })]
  })
};

/***/ }),

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ }),

/***/ "@wordpress/element":
/*!*********************************!*\
  !*** external ["wp","element"] ***!
  \*********************************/
/***/ ((module) => {

module.exports = window["wp"]["element"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!***************************************!*\
  !*** ./blocks/post-info/src/index.js ***!
  \***************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _modules__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../modules */ "./blocks/modules.js");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);
const {
  __
} = wp.i18n;
const {
  registerBlockType
} = wp.blocks;
const {
  useBlockProps,
  useInnerBlocksProps,
  InnerBlocks,
  useSetting
} = wp.blockEditor;
const {
  useEffect
} = wp.element;


registerBlockType('myconianhotel/post-info', {
  apiVersion: 2,
  title: __('Post Info', 'myconianhotel'),
  description: __('Some description'),
  icon: _modules__WEBPACK_IMPORTED_MODULE_0__.IconSet.postInfo,
  category: 'layout',
  attributes: {
    backgroundColor: {
      type: 'string'
      //default: 'white', It is declared inside index.js (themeDefaultBackground)
    }
  },
  edit(props) {
    const {
      attributes,
      setAttributes
    } = props;
    const {
      backgroundColor
    } = attributes;

    // Set the initial background color if it hasn't been set
    const defaultBackgroundSlug = useSetting('custom.defaultBackgroundSlug'); // Access custom theme setting
    useEffect(() => {
      if (!backgroundColor) {
        setAttributes({
          backgroundColor: defaultBackgroundSlug
        });
      }
    }, [backgroundColor, defaultBackgroundSlug]);
    const blockProps = useBlockProps({
      className: `alignfull is-layout-constrained has-${backgroundColor}-background-color has-background-color has-global-padding`
    });
    const TEMPLATE = [['myconianhotel/post-info-column', {
      metadata: {
        name: 'Content'
      }
    }, [['myconianhotel/post-terms', {
      makeTermsLink: true
    }], ['core/post-title', {
      level: 1
    }], ['myconianhotel/paragraph', {
      'placeholder': 'Add a description about accomodation.'
    }], ['myconianhotel/book-form']]], ['myconianhotel/post-info-column', {
      extraClasses: 'is-layout-flex',
      metadata: {
        name: 'Terms & attributes'
      }
    }, [['myconianhotel/post-acf-fields'], ['myconianhotel/post-terms', {
      taxonomy: 'accommodation_amenities',
      showTitle: true
    }], ['myconianhotel/post-terms', {
      taxonomy: 'accommodation_benefits',
      showTitle: true
    }]]]];
    const innerBlocksProps = useInnerBlocksProps({
      className: 'wp-block-columns wp-block-myconianhotel-columns is-layout-flex wp-block-columns-is-layout-flex'
    }, {
      allowedBlocks: ['myconianhotel/post-info-column'],
      template: TEMPLATE,
      templateLock: 'all'
    });
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      ...blockProps,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        ...innerBlocksProps
      })
    });
  },
  save(props) {
    const {
      attributes
    } = props;
    const {
      backgroundColor
    } = attributes;
    const blockProps = useBlockProps.save({
      className: `alignfull is-layout-constrained has-${backgroundColor}-background-color has-background-color has-global-padding`
    });
    const innerBlocksProps = useInnerBlocksProps.save({
      className: 'wp-block-columns wp-block-myconianhotel-columns is-layout-flex wp-block-columns-is-layout-flex'
    });
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      ...blockProps,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
        ...innerBlocksProps
      })
    });
  }
});

// Register 'myconianhotel/post-info-column' block

registerBlockType('myconianhotel/post-info-column', {
  apiVersion: 2,
  title: __('Post info Column', 'myconianhotel'),
  icon: 'columns',
  category: 'layout',
  attributes: {
    extraClasses: {
      type: 'string',
      default: 'is-layout-flow'
    }
  },
  supports: {
    inserter: false,
    // Prevents this block from appearing in the block inserter
    html: false
  },
  parent: ['myconianhotel/post-info'],
  // Restricts this block to be used only inside 'myconianhotel/post-teaser'

  edit(props) {
    const {
      attributes
    } = props;
    const {
      extraClasses
    } = attributes;
    const innerBlocksProps = useInnerBlocksProps({
      className: `wp-block-column wp-block-myconian-hotel-column ${extraClasses}`
    } /*, {
         template: template,
         allowedBlocks: [],
         templateLock: 'all'        
      }*/);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      ...innerBlocksProps
    });
  },
  save(props) {
    const {
      attributes
    } = props;
    const {
      extraClasses
    } = attributes;
    const blockProps = useBlockProps.save({
      className: `wp-block-column wp-block-myconian-hotel-column ${extraClasses}`
    });
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)("div", {
      ...blockProps,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx)(InnerBlocks.Content, {})
    });
  }
});
})();

/******/ })()
;
//# sourceMappingURL=index.js.map