const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { useBlockProps, InnerBlocks, useInnerBlocksProps, useSetting, InspectorControls } = wp.blockEditor;
const { PanelBody, SelectControl } = wp.components;
const { useEffect, Fragment } = wp.element;

registerBlockType('myconianhotel/post-teaser-feed', {
    apiVersion: 2,
    title: __('Post Teaser Feed'),
    description: __('Some description'),
    icon: 'columns',
    category: 'layout',
    supports: {
        //align: ['full'], // Only allow align full
        anchor: true,
        /*color: {
            background: true, // Native background color support
        }*/
    },
    edit: (props) => {
        const apiRoot = window.wpApiSettings?.root; // e.g., https://example.com/wp-json/
        const siteUrl = apiRoot?.replace(/\/wp-json\/?$/, ''); // Remove `/wp-json/`

        return (
            <div class="post-teaser-feed__preview">
                <div><p>Last update on<br/>{props.attributes.lastUpdate}<br/><br/><a href={siteUrl + '/wp-admin/options-general.php?page=myconianhotel-settings-options'} target="_blank">Force update</a></p></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        );
    },
    save: (props) => {
        return null; // Serverside render
    }
});