const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { useBlockProps, InnerBlocks, useInnerBlocksProps, useSetting, InspectorControls, BlockControls } = wp.blockEditor;
const { PanelBody,
        SelectControl, 
        ToolbarButton, 
        ToolbarGroup } = wp.components;
const { useEffect, useRef, Fragment } = wp.element;
import { CustomPanelColorSettings, IconSet } from '../../modules';

const alignPullBottomIcon = (
    <svg class="myconianhotel-svg-icon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 20 20">
        <rect fill="#000000" x="5" y="3" width="10" height="2"/>
        <rect fill="#000000" x="3" y="11" width="14" height="6"/>
        <rect fill="#000000" x="5" y="7" width="10" height="2"/>
    </svg>
);    

const alignPullTopIcon = (
    <svg class="myconianhotel-svg-icon" xmlns="http://www.w3.org/2000/svg" version="1.1" viewBox="0 0 20 20">
        <rect x="5" y="11" width="10" height="2"/>
        <rect x="3" y="3" width="14" height="6"/>
        <rect x="5" y="15" width="10" height="2"/>
    </svg>
);     

registerBlockType('myconianhotel/post-teaser-gallery', {
    apiVersion: 2,
    title: __('Post Teaser Gallery & Text (M)'),
    description: __('A two-column layout with a post teaser gallery on one side and text on the other.'),
    icon: IconSet.postTeaserGallery,
    category: 'layout',
    attributes: {
        backgroundColor: {
            type: 'string'
        },
        postSource: {
            type: 'string',
            default: 'manual'
        },
        mediaPosition: {
            type: 'string',
            default: 'right',
        },
        chosenTemplate: {
            type: 'string',
            default: 'manual'
        },
    },
    supports: {
        //align: ['full'], // Only allow align full
        anchor: true/*,
        color: {
            background: true, // Native background color support
        }*/
    },
    edit: (props) => {
        const { attributes, setAttributes, clientId } = props;
        const { backgroundColor, postSource, mediaPosition, chosenTemplate } = attributes;

        useEffect(() => {
            if ('feed' == postSource) {
                setAttributes({ backgroundColor: 'black' });
            } else {
                //setAttributes({ backgroundColor: '' });                
            }
        }, [postSource]);

        let templates = {
            manual: [
                ['myconianhotel/post-teaser', {makeCarousel: true, className: 'is-style-alternative', aspectRatio: '2/3'}],
                ['myconianhotel/group', {
                    className: 'wp-block-media-text__content is-layout-flow',
                    'metadata': {
                        'name': 'Content'
                    }
                }, [
                    ['myconianhotel/paragraph', {
                        textAlign: 'center',
                        fontSize: 'small',
                        placeholder: __('Subtitle', 'myconianhotel')
                    }],
                    ['myconianhotel/heading', {
                        level: 2,
                        textAlign: 'center',
                        placeholder: __('Heading', 'myconianhotel')
                    }],
                    ['myconianhotel/paragraph', {
                        textAlign: 'center',
                        placeholder: __('Content', 'myconianhotel')
                    }],
                    ['myconianhotel/buttons'],
                ]],
            ],
            manualSticky: [
                ['myconianhotel/post-teaser', {makeCarousel: false, parentIsSticky: true}],
                ['myconianhotel/group', {
                    className: 'wp-block-media-text__content is-layout-flow',
                    'metadata': {
                        'name': 'Content'
                    }
                }, [
                    ['myconianhotel/paragraph', {
                        textAlign: 'center',
                        fontSize: 'small',
                        placeholder: __('Subtitle', 'myconianhotel')
                    }],
                    ['myconianhotel/heading', {
                        level: 2,
                        textAlign: 'center',
                        placeholder: __('Heading', 'myconianhotel')
                    }],
                    ['myconianhotel/paragraph', {
                        textAlign: 'center',
                        placeholder: __('Content', 'myconianhotel')
                    }],
                    ['myconianhotel/buttons'],
                ]],
            ],
            'feed': [
                ['myconianhotel/post-teaser-feed'],
                ['myconianhotel/group', {
                    className: 'wp-block-media-text__content is-layout-flow',
                    'metadata': {
                        'name': 'Content'
                    }
                }, [
                    ['myconianhotel/paragraph', {
                        textAlign: 'center',
                        placeholder: __('Subtitle', 'myconianhotel')
                    }],
                    ['myconianhotel/heading', {
                        level: 2,
                        textAlign: 'center',
                        placeholder: __('Heading', 'myconianhotel')
                    }],
                    ['myconianhotel/paragraph', {
                        textAlign: 'center',
                        placeholder: __('Content', 'myconianhotel')
                    }],
                    ['myconianhotel/buttons'],
                ]],
            ]
        }

        // Track the last chosen template
        const lastTemplateRef = useRef(chosenTemplate);

        useEffect(() => {
            // If the template has changed, replace all blocks
            if ('manual' == postSource) {
                if (attributes.className?.includes('is-style-sticky')) {
                    setAttributes({chosenTemplate: 'manualSticky'});
                } else {
                    setAttributes({chosenTemplate: 'manual'});
                }
            } else {
                setAttributes(
                    {chosenTemplate: 'feed', className: 'is-style-default'}
                );
            }
        }, [postSource]);

        useEffect(() => {
            if ('manual' == postSource) {
                if (attributes.className?.includes('is-style-sticky')) {
                    setAttributes({chosenTemplate: 'manualSticky'});
                    setAttributes({ backgroundColor: 'lightbrown' });
                } else {
                    setAttributes({chosenTemplate: 'manual'});
                }
            } else {
                setAttributes(
                    {chosenTemplate: 'feed', className: 'is-style-default'}
                );
            }
        }, [attributes.className]);


        // Effect to update allowed blocks and replace inner blocks
        useEffect(() => {
            // If the template has changed, replace all blocks
            if (lastTemplateRef.current !== chosenTemplate) { console.log('----->');
                const { replaceInnerBlocks } = wp.data.dispatch('core/block-editor');
                replaceInnerBlocks(clientId, wp.blocks.createBlocksFromInnerBlocksTemplate(templates[chosenTemplate]));
                lastTemplateRef.current = chosenTemplate;
            }
        }, [chosenTemplate, attributes.className, clientId]);

        // Set the initial background color if it hasn't been set
        const defaultBackgroundSlug  = useSetting('custom.defaultBackgroundSlug'); // Access custom theme setting
        useEffect(() => {
            if (!backgroundColor) {
                setAttributes({ backgroundColor: defaultBackgroundSlug });
            }
        }, [backgroundColor]);

        const blockProps = useBlockProps({
            className: [
                'alignfull', // Align classesss
                attributes.className?.includes('is-style-sticky') ? 'is-layout-constrained has-global-padding' : '',
                'feed' == postSource ? 'is-style-alternative' : '',
                backgroundColor ? `has-${backgroundColor}-background-color has-background-color` : '', // Background color class
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        const innerBlockProps = useInnerBlocksProps({
            className: [
                'wp-block-myconianhotel-media-text wp-block-media-text', // Default class
                mediaPosition ? `has-media-on-the-${mediaPosition}` : '', // Media positioning class
                'is-stacked-on-mobile' // Mobile stacking class
            ].filter(Boolean).join(' ') // Filter out empty class values
        }, {
            templateLock: 'all',
            template: templates[chosenTemplate],
            allowedBlocks: []        
        });
        
        return (
            <Fragment>
                <BlockControls>
                    <ToolbarGroup>
                        <ToolbarButton
                            icon="align-pull-right"
                            label={__('Show media on right')}
                            isActive={mediaPosition === 'right'}
                            onClick={() => {setAttributes({mediaPosition: 'right'})}}
                        />
                        <ToolbarButton
                            icon={alignPullTopIcon}
                            label={__('Show media on top')}
                            isActive={mediaPosition === 'top'}
                            onClick={() => {setAttributes({mediaPosition: 'top'})}}
                        />                        
                        <ToolbarButton
                            icon={alignPullBottomIcon}
                            label={__('Show media on bottom')}
                            isActive={mediaPosition === 'bottom'}
                            onClick={() => {setAttributes({mediaPosition: 'bottom'})}}
                        />                        
                    </ToolbarGroup>
                </BlockControls>
                <InspectorControls>
                    { 'manual' == chosenTemplate && (
                    <CustomPanelColorSettings
                        setAttributes={setAttributes}
                        backgroundColor={backgroundColor}
                        palette={'collection' == myconianhotelBlockPostTeaserGallery.colorscheme ? ['lightgray', 'lightergray', 'white'] : ['darkblue', 'lightgray', 'lightergray', 'white'] }
                    />)}
                    <PanelBody title="Posts">
                    <SelectControl
                        label="Select an Option"
                        value={postSource} // The currently selected option
                        options={[
                            { label: 'Manual entry', value: 'manual' },
                            { label: 'Magazine', value: 'feed' },
                        ]}
                        onChange={(value) => setAttributes({postSource: value})}
                    />
                </PanelBody>
                </InspectorControls>
                <div {...blockProps}>
                    <div {...innerBlockProps}></div>
                </div>
            </Fragment>
        );
    },
    save: (props) => {
        const { attributes } = props;
        const { mediaPosition, backgroundColor, postSource } = attributes;

        const blockProps = useBlockProps.save({
            className: [
                'alignfull', // Align classesss
                attributes.className?.includes('is-style-sticky') ? 'is-layout-constrained has-global-padding' : '',
                mediaPosition === 'top' || mediaPosition === 'bottom' ? 'is-layout-constrained has-global-padding' : '',
                'feed' == postSource ? 'is-style-alternative' : '',
                backgroundColor ? `has-${backgroundColor}-background-color has-background-color` : '', // Background color class
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        const innerBlockProps = useInnerBlocksProps.save({
            className: [
                'wp-block-myconianhotel-media-text wp-block-media-text', // Default class
                mediaPosition ? `has-media-on-the-${mediaPosition}` : '', // Media positioning class
                'is-stacked-on-mobile' // Mobile stacking class
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        return (
            <div {...blockProps}>
                <div {...innerBlockProps}></div>
            </div>
        );
    }
});

 wp.blocks.registerBlockStyle('myconianhotel/post-teaser-gallery', {
    name: 'sticky',
    label: __('Sticky Gallery', 'myconianhotel'),
});

/*const { __ } = wp.i18n;
const { registerBlockType, createBlock } = wp.blocks;
const { useBlockProps, InnerBlocks, InspectorControls, useInnerBlocksProps, useSetting } = wp.blockEditor;
const { PanelBody, RangeControl } = wp.components;
const { useEffect, useState } = wp.element;

const TEMPLATE = [
    ['myconianhotel/group', {
        className: 'wp-block-media-text__content is-layout-flow',
        'metadata': {
            'name': 'Content'
        }
    }, [
        ['myconianhotel/paragraph', {
            textAlign: 'center',
            placeholder: __('Subtitle', 'myconianhotel')
        }],
        ['myconianhotel/heading', {
            level: 2,
            textAlign: 'center',
            placeholder: __('Heading', 'myconianhotel')
        }],
        ['myconianhotel/paragraph', {
            textAlign: 'center',
            placeholder: __('Content', 'myconianhotel')
        }],
        ['myconianhotel/buttons'],
    ]],
    ['myconianhotel/group', {
        className: 'wp-block-myconianhotel-gallery__slider owl-carousel owl-theme-autowidth',
        'metadata': {
            'name': 'Gallery'
        }
    }],
];

registerBlockType('myconianhotel/post-teaser-gallery', {
    apiVersion: 2,
    title: __('Post Teaser Gallery & Text (M)'),
    description: __('A two-column layout with a post teaser gallery on one side and text on the other.'),
    icon: 'align-pull-left',
    category: 'layout',
    attributes: {
        columns: {
            type: 'number',
            default: 2,
        }
    },
    supports: {
        //align: ['full'], // Only allow align full
        anchor: true,
        color: {
            background: true, // Native background color support
        }
    },
    edit: (props) => {
        const { attributes, setAttributes, clientId } = props;
        const { columns, backgroundColor } = attributes;
        const [localColumns, setLocalColumns] = useState(columns);
        const { getBlocksByClientId } = wp.data.select('core/block-editor');
        const { replaceInnerBlocks, updateBlockAttributes } = wp.data.dispatch('core/block-editor');
        const innerBlocks = getBlocksByClientId(clientId)[0].innerBlocks;

        // Set the initial background color if it hasn't been set
        const defaultBackgroundSlug  = useSetting('custom.defaultBackgroundSlug'); // Access custom theme setting
        useEffect(() => {
            if (!backgroundColor) {
                setAttributes({ backgroundColor: defaultBackgroundSlug });
            }
        }, [backgroundColor, defaultBackgroundSlug]);

        // Ensure the correct number of columns is rendered
        useEffect(() => {
            if (innerBlocks.length === 0 && localColumns > 0) {
                const defaultColumns = Array.from({ length: localColumns }, (value, index) => {
                    return createBlock('myconianhotel/post-teaser-column', {
                        aspectratio: '3/4',
                        lastColumn: index == localColumns-1 ? true : false,
                        firstColumn: index == 0 ? true : false
                        });
                });;
                replaceInnerBlocks(clientId, defaultColumns, false);
            } else if (innerBlocks.length !== localColumns) {
                updateColumns(localColumns);
            }
        }, [localColumns]);

        const updateColumns = (newColumnCount) => {
            const currentColumnCount = innerBlocks.length;
            let newInnerBlocks = [...innerBlocks];

            for (let i = 0; i < newInnerBlocks.length; i++) {
                newInnerBlocks[i].attributes.lastColumn = false;
            }

            if (newColumnCount > currentColumnCount) {
                for (let i = currentColumnCount; i < newColumnCount; i++) {
                    newInnerBlocks.push(createBlock('myconianhotel/post-teaser-column', {
                        aspectratio: '3/4',
                        lastColumn: i == newColumnCount-1 ? true : false
                        }));
                }
            } else if (newColumnCount < currentColumnCount) {
                newInnerBlocks = newInnerBlocks.slice(0, newColumnCount);
                newInnerBlocks[newColumnCount-1].attributes.lastColumn = true;
                newInnerBlocks[0].attributes.firstColumn = true;
            }

            replaceInnerBlocks(clientId, newInnerBlocks, false);
            setAttributes({ columns: newColumnCount });
        };

        const handleSliderChange = (newColumns) => {
            setLocalColumns(newColumns);
        };

        const blockProps = useBlockProps({
            className: [
                'alignfull', // Align classesss
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        const innerBlocksProps = useInnerBlocksProps({
            className: [
                'wp-block-myconianhotel-media-text wp-block-media-text', // Default class
                'is-stacked-on-mobile', // Mobile stacking class                
                'has-media-on-the-right' // Media positioning class
            ].filter(Boolean).join(' ') // Filter out empty class values
        }, {
            templateLock: 'all',
            template: TEMPLATE,
            allowedBlocks: []        
        });
        
        return (
            <>
                <InspectorControls>
                    <PanelBody title={__('Column Settings', 'myconianhotel')}>
                        <RangeControl
                            label={__('Columns', 'myconianhotel')}
                            value={localColumns}
                            onChange={handleSliderChange}
                            min={1}
                            max={3}
                        />
                    </PanelBody>
                </InspectorControls>
                <div {...blockProps}>
                    <div {...innerBlocksProps}></div>
                </div>
            </>
        );
    },
    save: (props) => {
        const { attributes } = props;
        const { mediaPosition } = attributes;

        const blockProps = useBlockProps.save({
            className: [
                'alignfull', // Align classesss
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        const innerBlocksProps = useInnerBlocksProps.save({
            className: [
                'wp-block-myconianhotel-media-text wp-block-media-text', // Default class
                'is-stacked-on-mobile', // Mobile stacking class                
                'has-media-on-the-right' // Media positioning class
            ].filter(Boolean).join(' ') // Filter out empty class values
        });

        return (
            <div {...blockProps}>
                <div {...innerBlocksProps}></div>
            </div>
        );
    }
});*/