/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "react/jsx-runtime":
/*!**********************************!*\
  !*** external "ReactJSXRuntime" ***!
  \**********************************/
/***/ ((module) => {

module.exports = window["ReactJSXRuntime"];

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!****************************************!*\
  !*** ./blocks/post-terms/src/index.js ***!
  \****************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "react/jsx-runtime");
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);

// https://chatgpt.com/c/674461e0-80e0-8003-bef0-48b4939676e6
// https://chatgpt.com/c/6744a5bc-ff6c-8003-b382-20b85501898b

const {
  registerBlockType
} = wp.blocks;
const {
  InspectorControls,
  useBlockProps
} = wp.blockEditor;
const {
  PanelBody,
  SelectControl,
  ToggleControl
} = wp.components;
const {
  useState,
  useEffect,
  Fragment
} = wp.element;
const {
  __
} = wp.i18n;
const apiFetch = wp.apiFetch;
registerBlockType('myconianhotel/post-terms', {
  title: 'Accommodation Taxonomies List',
  icon: 'list-view',
  category: 'widgets',
  attributes: {
    taxonomy: {
      type: 'string',
      default: 'accommodation_type' // Default taxonomy slug
    },
    showCount: {
      type: 'boolean',
      default: false
    },
    showTitle: {
      type: 'boolean',
      default: false
    },
    makeTermsLink: {
      type: 'boolean',
      default: false
    },
    taxonomyName: {
      type: 'string',
      default: '' // Dynamically fetched taxonomy name
    },
    terms: {
      type: 'array',
      default: []
    }
  },
  edit: ({
    attributes,
    setAttributes
  }) => {
    const {
      taxonomy,
      showCount,
      showTitle,
      makeTermsLink,
      taxonomyName,
      terms
    } = attributes;
    const [taxonomies, setTaxonomies] = useState([]);
    const [loading, setLoading] = useState(false);
    const blockProps = useBlockProps({
      className: 'wp-block-myconianhotel-post-terms wp-block is-layout-flow'
    });

    // Fetch taxonomies for accommodation
    useEffect(() => {
      if (!taxonomy) return; // No taxonomy selected yet

      apiFetch({
        path: '/wp/v2/taxonomies'
      }).then(data => {
        // Filter the taxonomies related to 'accommodation'
        const accommodationTaxonomies = Object.values(data).filter(taxonomyItem => taxonomyItem.types.includes('accommodation'));
        setTaxonomies(accommodationTaxonomies);

        // Find the selected taxonomy
        const selectedTaxonomy = accommodationTaxonomies.find(taxonomyItem => taxonomyItem.slug === taxonomy);
        if (selectedTaxonomy) {
          setAttributes({
            taxonomyName: selectedTaxonomy.name
          });
        } else {
          console.warn('Selected taxonomy not found:', taxonomy);
          setAttributes({
            taxonomyName: ''
          });
        }
      }).catch(error => {
        console.error('Error fetching taxonomies:', error);
        setAttributes({
          taxonomyName: ''
        });
      });
    }, [taxonomy]);

    // Fetch terms for the selected taxonomy associated with the current post
    useEffect(() => {
      const postId = wp.data.select('core/editor').getCurrentPostId(); // Get current post ID
      if (postId && taxonomy) {
        setLoading(true);
        apiFetch({
          path: `/wp/v2/${taxonomy}?post=${postId}`
        }).then(fetchedTerms => {
          setAttributes({
            terms: fetchedTerms
          });
        }).catch(error => console.error(error)).finally(() => setLoading(false));
      }
    }, [taxonomy]);
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      ...blockProps,
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(InspectorControls, {
        children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(PanelBody, {
          title: "Settings",
          initialOpen: true,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SelectControl, {
            label: "Select taxonomy",
            value: taxonomy,
            options: taxonomies.map(taxonomy => ({
              label: taxonomy.name,
              value: taxonomy.slug
            })),
            onChange: value => setAttributes({
              taxonomy: value
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ToggleControl, {
            label: "Display term title",
            checked: showTitle,
            onChange: value => setAttributes({
              showTitle: value
            })
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ToggleControl, {
            label: "Make terms a link",
            checked: makeTermsLink,
            onChange: value => setAttributes({
              makeTermsLink: value
            })
          })]
        })
      }), loading ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
        children: "Loading terms..."
      }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(Fragment, {
        children: [showTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
          children: taxonomyName
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", {
          children: terms.length ? terms.map(term => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", {
            children: [term.name, " ", showCount && `(${term.count})`]
          }, term.id)) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", {
            children: `Add ${taxonomyName} from the right sidebar`
          })
        })]
      })]
    });
  },
  save: ({
    attributes
  }) => {
    return null; // server side render

    const {
      terms,
      showCount,
      showTitle,
      makeTermsLink,
      taxonomyName
    } = attributes;
    const blockProps = useBlockProps.save({
      className: 'wp-block-myconianhotel-post-terms wp-block is-layout-flow'
    });
    if (!terms || terms.length === 0) {
      return null;
    }
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", {
      ...blockProps,
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(Fragment, {
        children: [showTitle && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", {
          children: taxonomyName
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", {
          children: terms.map(term => /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", {
            children: [makeTermsLink ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", {
              href: term.link,
              children: term.name
            }) : term.name, showCount && ` (${term.count})`]
          }, term.id))
        })]
      })
    });
  }
});
})();

/******/ })()
;
//# sourceMappingURL=index.js.map