// https://chatgpt.com/c/674461e0-80e0-8003-bef0-48b4939676e6
// https://chatgpt.com/c/6744a5bc-ff6c-8003-b382-20b85501898b

const { registerBlockType } = wp.blocks;
const { InspectorControls, useBlockProps } = wp.blockEditor;
const { PanelBody, SelectControl, ToggleControl } = wp.components;
const { useState, useEffect, Fragment } = wp.element;
const { __ } = wp.i18n;
const apiFetch = wp.apiFetch;

registerBlockType('myconianhotel/post-terms', {
    title: 'Accommodation Taxonomies List',
    icon: 'list-view',
    category: 'widgets',
    attributes: {
        taxonomy: {
            type: 'string',
            default: 'accommodation_type', // Default taxonomy slug
        },
        showCount: {
            type: 'boolean',
            default: false,
        },
        showTitle: {
            type: 'boolean',
            default: false,
        },
        makeTermsLink: {
            type: 'boolean',
            default: false,
        },
        taxonomyName: {
            type: 'string',
            default: '', // Dynamically fetched taxonomy name
        },
        terms: {
            type: 'array',
            default: [],
        },
    },
    edit: ({ attributes, setAttributes }) => {
        const { taxonomy, showCount, showTitle, makeTermsLink, taxonomyName, terms } = attributes;
        const [taxonomies, setTaxonomies] = useState([]);
        const [loading, setLoading] = useState(false);
        const blockProps = useBlockProps({
            className: 'wp-block-myconianhotel-post-terms wp-block is-layout-flow'
        });

        // Fetch taxonomies for accommodation
        useEffect(() => {
            if (!taxonomy) return; // No taxonomy selected yet

            apiFetch({ path: '/wp/v2/taxonomies' })
                .then((data) => {
                    // Filter the taxonomies related to 'accommodation'
                    const accommodationTaxonomies = Object.values(data).filter(
                        (taxonomyItem) => taxonomyItem.types.includes('accommodation')
                    );

                    setTaxonomies(accommodationTaxonomies);

                    // Find the selected taxonomy
                    const selectedTaxonomy = accommodationTaxonomies.find(
                        (taxonomyItem) => taxonomyItem.slug === taxonomy
                    );

                    if (selectedTaxonomy) {
                        setAttributes({ taxonomyName: selectedTaxonomy.name });
                    } else {
                        console.warn('Selected taxonomy not found:', taxonomy);
                        setAttributes({ taxonomyName: '' });
                    }
                })
                .catch((error) => {
                    console.error('Error fetching taxonomies:', error);
                    setAttributes({ taxonomyName: '' });
                });
        }, [taxonomy]);

        // Fetch terms for the selected taxonomy associated with the current post
        useEffect(() => {
            const postId = wp.data.select('core/editor').getCurrentPostId(); // Get current post ID
            if (postId && taxonomy) {
                setLoading(true);
                apiFetch({
                    path: `/wp/v2/${taxonomy}?post=${postId}`,
                })
                    .then((fetchedTerms) => {
                        setAttributes({ terms: fetchedTerms });
                    })
                    .catch((error) => console.error(error))
                    .finally(() => setLoading(false));
            }
        }, [taxonomy]);

        return (
            <div {...blockProps}>
                <InspectorControls>
                    <PanelBody title="Settings" initialOpen={true}>
                        <SelectControl
                            label="Select taxonomy"
                            value={taxonomy}
                            options={taxonomies.map((taxonomy) => ({
                                label: taxonomy.name,
                                value: taxonomy.slug,
                            }))}
                            onChange={(value) => setAttributes({ taxonomy: value })}
                        />
                        <ToggleControl
                            label="Display term title"
                            checked={showTitle}
                            onChange={(value) => setAttributes({ showTitle: value })}
                        />
                        <ToggleControl
                            label="Make terms a link"
                            checked={makeTermsLink}
                            onChange={(value) => setAttributes({ makeTermsLink: value })}
                        />
                        {/*<ToggleControl
                            label="Show Post Counts"
                            checked={showCount}
                            onChange={(value) => setAttributes({ showCount: value })}
                        />*/}
                    </PanelBody>
                </InspectorControls>
                {loading ? (
                    <p>Loading terms...</p>
                ) : (
                    <Fragment>
                        {showTitle && <p>{taxonomyName}</p>}
                        <ul>
                            {terms.length ? terms.map((term) => (
                                <li key={term.id}>
                                    {term.name} {showCount && `(${term.count})`}
                                </li>
                            )) : (
                                <li>{`Add ${taxonomyName} from the right sidebar`}</li>
                            )}
                        </ul>
                    </Fragment>
                )}
            </div>
        );
    },
    save: ({ attributes }) => {
        


        return null; // server side render



        const { terms, showCount, showTitle, makeTermsLink, taxonomyName } = attributes;
        const blockProps = useBlockProps.save({
            className: 'wp-block-myconianhotel-post-terms wp-block is-layout-flow'
        });

        if (!terms || terms.length === 0) {
            return null;
        }

        return (
            <div {...blockProps}>
                <Fragment>
                    {showTitle && <p>{taxonomyName}</p>}
                    <ul>
                        {terms.map((term) => (
                            <li key={term.id}>
                                {makeTermsLink ? (
                                    <a href={term.link}>{term.name}</a>
                                ) : (
                                    term.name
                                )}
                                
                                {showCount && ` (${term.count})`}
                            </li>
                        ))}
                    </ul>
                </Fragment>
            </div>
        );
    },
});




